<?php /* FIELDS */

wpj_add_shortcode( 'job_fields', function( $atts = '' ) {
	ob_start();

	$field_content_class = new WPJJobsNewEditFieldsContent();

	$_atts = shortcode_atts( [
		'field_type'    => '',
		'placeholder'   => '',
		'required'      => '',
		'include_label' => '',
		'instructions'  => '',
	], $atts );

	if ( method_exists( $field_content_class, $_atts['field_type'] ) ) {
		if ( $_atts['placeholder'] && ! in_array( $_atts['field_type'], [ 'package', 'instant_delivery', 'cover', 'image', 'preview', 'audio', 'tos' ] ) ) {
			if ( $_atts['required'] )
				call_user_func_array( [ $field_content_class, $_atts['field_type'] ], [ 'placeholder' => $_atts['placeholder'], 'required' => $_atts['required'] ] );

			elseif ( $_atts['include_label'] )
				call_user_func_array( [ $field_content_class, $_atts['field_type'] ], [ 'placeholder' => $_atts['placeholder'], 'include_label' => $_atts['include_label'] ] );

			else
				call_user_func_array( [ $field_content_class, $_atts['field_type'] ], [ 'placeholder' => $_atts['placeholder'] ] );

		} else
			call_user_func( [ $field_content_class, $_atts['field_type'] ] );

		if ( WPJ_Form::get( 'action' ) == 'edit-job' ) {
			$rejected_name = $_atts['field_type'] != 'extra_description' ? str_replace( 'job_', '', 'job_' . $_atts['field_type'] ) : 'extra1';
			wpj_display_popup_content( $_atts['instructions'], 'edit', 'job', WPJ_Form::get( 'jobid' ), $rejected_name, 'job_' . $_atts['field_type'] );

		} else
			wpj_display_popup_content( $_atts['instructions'], 'new', 'job', WPJ_Form::get( 'jobid' ), '', 'job_' . $_atts['field_type'] );

	}

	return ob_get_clean();
});

wpj_add_shortcode( 'request_fields', function( $atts = '' ) {
	ob_start();

	$field_content_class = new WPJRequestsNewEditFieldsContent();

	$_atts = shortcode_atts( [
		'field_type'   => '',
		'placeholder'  => '',
		'instructions' => '',
	], $atts );

	if ( method_exists( $field_content_class, $_atts['field_type'] ) ) {
		if ( $_atts['placeholder'] && $_atts['field_type'] != 'attachments' )
			call_user_func_array( [ $field_content_class, $_atts['field_type'] ], [ 'placeholder' => $_atts['placeholder'] ] );
		else
			call_user_func( [ $field_content_class, $_atts['field_type'] ] );

		if ( WPJ_Form::get( 'action' ) == 'edit-request' )
			wpj_display_popup_content( $_atts['instructions'], 'edit', 'request', WPJ_Form::get( 'requestid' ), $_atts['field_type'], 'request_' . $_atts['field_type'] );
		else
			wpj_display_popup_content( $_atts['instructions'], 'new', 'request', WPJ_Form::get( 'requestid' ), '', 'request_' . $_atts['field_type'] );
	}

	return ob_get_clean();
});

wpj_add_shortcode( 'user_fields', function( $atts = [] ) {
	ob_start();

	$field_content_class = new WPJUserProfileFieldsContent();

	$_atts = shortcode_atts( [
		'field_type' => '',
		'section'    => ''
	], $atts );

	if ( $_atts['section'] )
		call_user_func_array( [ $field_content_class, $_atts['field_type'] ], [ 'section' => $_atts['section'] ] );
	else
		call_user_func( [ $field_content_class, $_atts['field_type'] ] );

	return ob_get_clean();
});

wpj_add_shortcode( 'job_custom_field', function( $atts = [] ) {
	$_atts = shortcode_atts( [
		'id'   => wpj_get_post_id(),
		'name' => '',
		'type' => 'text'
	], $atts );

	$saved_value = get_post_meta( $_atts['id'], $_atts['name'], true );

	if ( is_string( $saved_value ) ) {
		$value_decoded = wpj_json_decode( $saved_value, true );

		if ( json_last_error() === JSON_ERROR_NONE ) $saved_value = $value_decoded;
	}

	if ( is_array( $saved_value ) )
		$content = wpj_multidimensional_array_has_value( $saved_value ) ? implode( ', ', str_replace( '_', ' ', $saved_value ) ) : '';

	else
		$content = wpautop( str_replace( '_', ' ', $saved_value ) );

	if ( $content && $_atts['type'] == 'tag' ) {
		$tags = explode( ',', strip_tags( $content ) );
		$tags = array_filter( $tags );

		if ( wpj_multidimensional_array_has_value( $tags ) ) {
			$content = '<div class="general-tags-wrapper">';

				foreach ( $tags as $tag ) {
					$content .= '<a href="' . get_bloginfo() . '/tag/' . trim( $tag ) . '" rel="tag" class="js-internal">' . trim( $tag ) . '</a>';
				}

			$content .= '</div>';
		}
	}

	return '<div class="job-custom-field ' . str_replace( '_', '-', $_atts['name'] ) . '">' . $content . '</div>';
});

wpj_add_shortcode( 'request_custom_field', function( $atts = [] ) {
	$_atts = shortcode_atts( [
		'id'   => wpj_get_post_id(),
		'name' => '',
		'type' => 'text'
	], $atts );

	$saved_value = get_post_meta( $_atts['id'], $_atts['name'], true );

	if ( is_string( $saved_value ) ) {
		$value_decoded = wpj_json_decode( $saved_value, true );

		if ( json_last_error() === JSON_ERROR_NONE ) $saved_value = $value_decoded;
	}

	if ( is_array( $saved_value ) )
		$content = wpj_multidimensional_array_has_value( $saved_value ) ? implode( ', ', str_replace( '_', ' ', $saved_value ) ) : '';

	else
		$content = wpautop( str_replace( '_', ' ', $saved_value ) );

	if ( $content && $_atts['type'] == 'tag' ) {
		$tags = explode( ',', strip_tags( $content ) );
		$tags = array_filter( $tags );

		if ( wpj_multidimensional_array_has_value( $tags ) ) {
			$content = '<div class="general-tags-wrapper">';

				foreach ( $tags as $tag ) {
					$content .= '<a href="' . get_bloginfo() . '/tag/' . trim( $tag ) . '" rel="tag" class="js-internal">' . trim( $tag ) . '</a>';
				}

			$content .= '</div>';
		}
	}

	return '<div class="request-custom-field ' . str_replace( '_', '-', $_atts['name'] ) . '">' . $content . '</div>';
});

wpj_add_shortcode( 'user_custom_field', function( $atts = [] ) {
	$_atts = shortcode_atts( [
		'id'   => wpj_get_user_id(),
		'name' => '',
		'type' => 'text'
	], $atts );

	$saved_value = get_user_meta( $_atts['id'], $_atts['name'], true );

	if ( is_string( $saved_value ) ) {
		$value_decoded = wpj_json_decode( $saved_value, true );

		if ( json_last_error() === JSON_ERROR_NONE ) $saved_value = $value_decoded;
	}

	if ( is_array( $saved_value ) )
		$content = wpj_multidimensional_array_has_value( $saved_value ) ? implode( ', ', str_replace( '_', ' ', $saved_value ) ) : '';

	else
		$content = wpautop( str_replace( '_', ' ', $saved_value ) );

	if ( $content && $_atts['type'] == 'tag' ) {
		$tags = explode( ',', strip_tags( $content ) );
		$tags = array_filter( $tags );

		if ( wpj_multidimensional_array_has_value( $tags ) ) {
			$content = '<div class="general-tags-wrapper">';

				foreach ( $tags as $tag ) {
					$content .= '<a href="' . get_bloginfo() . '/tag/' . trim( $tag ) . '" rel="tag" class="js-internal">' . trim( $tag ) . '</a>';
				}

			$content .= '</div>';
		}
	}

	return '<div class="user-custom-field ' . str_replace( '_', '-', $_atts['name'] ) . '">' . $content . '</div>';
});