<?php /* FORM */

wpj_add_shortcode( 'input', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	$atts['sub_type'] = ! empty( $atts['type'] ) ? $atts['type'] : 'text';

	if ( $atts['name'] == 'email' ) {
		$user_info     = get_userdata( get_current_user_id() );

		$atts['value'] = apply_filters( 'wpj_user_email_settings_filter', empty( $_POST['email'] ) ? $user_info->user_email : wpj_stripslashes( $_POST['email'] ), get_current_user_id() );
	}

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	if ( $atts['sub_type'] == 'checkbox' || $atts['sub_type'] == 'radio' ) {
		$atts['values'] = array_map( 'trim', explode( ',', $atts['values'] ) );

		return $form_class->defined_value_fields( $atts );
	}

	return $form_class->input_fields( $atts );
});

wpj_add_shortcode( 'textarea', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	return $form_class->textarea_fields( $atts );
});

wpj_add_shortcode( 'location', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	if ( wpj_is_page( 'wpjobster_post_new_page_id' ) || ( isset( $atts['parent'] ) && $atts['parent'] == 'job' ) ) {
		$atts['value_lat']  = get_post_meta( WPJ_Form::get( 'jobid' ), $atts['latitude_name'], true );
		$atts['value_long'] = get_post_meta( WPJ_Form::get( 'jobid' ), $atts['longitude_name'], true );

	} elseif ( wpj_is_page( 'wpjobster_new_request_page_id' ) || ( isset( $atts['parent'] ) && $atts['parent'] == 'request' ) ) {
		$atts['value_lat']  = get_post_meta( WPJ_Form::get( 'requestid' ), $atts['latitude_name'], true );
		$atts['value_long'] = get_post_meta( WPJ_Form::get( 'requestid' ), $atts['longitude_name'], true );

	} else {
		$atts['value_lat']  = wpj_user( get_current_user_id(), $atts['latitude_name'] );
		$atts['value_long'] = wpj_user( get_current_user_id(), $atts['longitude_name'] );

	}

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	return $form_class->googleMap( $atts );
});

wpj_add_shortcode( 'location_unit', function( $atts = '' ) {
	return wpj_get_option( 'wpjobster_locations_unit' ) ? wpj_translate_string( wpj_get_option( 'wpjobster_locations_unit' ) ) : false;
});

wpj_add_shortcode( 'select', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	$atts['type'] = 'select';

	if ( ! is_array( $atts['values'] ) && function_exists( $atts['values'] ) ) {
		$atts['val_from_key'] = true;
	}

	$atts['values'] = ! is_array( $atts['values'] ) && function_exists( $atts['values'] ) ? $atts['values']() : array_map( 'trim', explode( ',', $atts['values'] ) );

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	return $form_class->defined_value_fields( $atts );
});

wpj_add_shortcode( 'slider', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	return $form_class->slider( $atts );
});

wpj_add_shortcode( 'tag', function( $atts = '' ) {
	$atts = wpj_get_shortcode_args( $atts );

	$form_class = new WPJ_Custom_Fields( $atts['item_id'], $atts['parent'] );

	return $form_class->tags( $atts );
});

wpj_add_shortcode( 'message', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_message', [ 'args' => $atts ] );
});

wpj_add_shortcode( 'nonce', function( $atts = '' ) {
	ob_start();

	$_atts = shortcode_atts( [
		'action_name' => '',
		'nonce_name'  => ''
	], $atts );

	wp_nonce_field( $_atts['action_name'], $_atts['nonce_name'] );

	return ob_get_clean();
});

wpj_add_shortcode( 'file_upload_form', function( $atts = '' ) {
	ob_start();

	$_atts = shortcode_atts( ['name' => '', 'placeholder' => ''], $atts );

	wpj_display_file_upload_form( 1, 'file_upload_' . $_atts['name'], 'hidden_files_' . $_atts['name'], $_atts['name'], false, $_atts['placeholder'] );

	return ob_get_clean();
});

wpj_add_shortcode( 'attachments_list', function( $atts = '' ) {
	ob_start();

	$_atts = shortcode_atts( [
		'meta_name'     => '',
		'title'         => false,
		'title_label'   => __( 'Documents', 'wpjobster' ),
		'file_size'     => true,
		'delete_action' => true
	], $atts );

	$pid = wpj_get_post_id();

	$attachments_arr = get_post_meta( $pid, $_atts['meta_name'], true );

	wpj_display_attachments_list(
		$attachments_arr,
		$pid,
		$_atts['meta_name'],
		$_atts['title'],
		$_atts['title_label'],
		$_atts['file_size'],
		$_atts['delete_action']
	);

	return ob_get_clean();
});

wpj_add_shortcode( 'do_action', function( $atts = '' ) {
	ob_start();

	$_atts = shortcode_atts( [ 'action_name' => '' ], $atts );

	do_action( $_atts['action_name'] );

	return ob_get_clean();
});