<?php /* MODAL */

wpj_add_shortcode( 'authentication_modals_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_authentication_modals' );
});

wpj_add_shortcode( 'job_modals_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_job_modals' );
});

wpj_add_shortcode( 'request_modals_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_request_modals' );
});

wpj_add_shortcode( 'order_modals_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_order_modals', [ 'order' => '' ] );
});

wpj_add_shortcode( 'user_transactions_modal_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_export_user_transactions_modal', [ 'uid' => '' ] );
});

wpj_add_shortcode( 'user_delete_account_modal_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_delete_account_modal' );
});

wpj_add_shortcode( 'request_custom_offer_modal_init', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_init_request_custom_offer_modal', [ 'args' => $atts ] );
});

wpj_add_shortcode( 'send_custom_offer_modal_init', function( $atts = '' ) {
	$defaults = [
		'unique_id'       => wpj_get_user_id(),
		'id'              => wpj_get_user_id(),
		'title'           => __( 'Send custom offer', 'wpjobster' ),
		'offer_type'      => 'send',
		'current_user_id' => get_current_user_id(),
		'post_author_id'  => wpj_get_user_id(),
		'page'            => '',
		'oid'             => '',
		'extra'           => '',
		'label_type'      => '',
		'label_icon'      => '',
		'is_error'        => false
	];

	if ( wpj_get_user_id() != get_current_user_id() && apply_filters( 'hide_for_buyers', true, get_current_user_id() ) ) {
		if ( wpj_get_option( 'wpjobster_active_job_cutom_offer' ) == 'yes' && wpj_get_user_jobs_count( get_current_user_id(), 'active' ) <= 0 ) {
			$defaults['is_error'] = true;
		}

	} else {
		return '<style>.kt-btn-wrap .kt-button.message-custom-offer-action-btn{display:none;}</style>'; // for page builder

	}

	$_atts = shortcode_atts( $defaults, $atts );

	return wpj_fnc_to_shortcode( $atts, 'wpj_init_send_custom_offer_modal', [ 'args' => $_atts ] );
});