<?php /* ORDER */

wpj_add_shortcode( 'bank_details', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_bank_details' );
});

wpj_add_shortcode( 'bank_job_payment_proof', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_bank_job_payment_proof', [ 'order' => '' ] );
});

wpj_add_shortcode( 'order_notices', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_notices', [ 'oid' => '' ] );
});

wpj_add_shortcode( 'order_timer', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_timer', [ 'order' => '' ] );
});

wpj_add_shortcode( 'camouflaged_order', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_camouflaged_order', [ 'order' => '', 'with_link' => '' ] );
});

wpj_add_shortcode( 'order_status', function( $atts = [] ) {
	$_atts = shortcode_atts( [ 'oid' => '', 'include_parentheses' => true ], $atts );

	return wpj_get_order_status( $_atts['oid'], $_atts['include_parentheses'] );
});

wpj_add_shortcode( 'seller_name', function( $atts = '' ) {
	$seller_id = wpj_get_seller_id();

	return '<a href="' . wpj_get_user_profile_link( $seller_id ) . '">' . wpj_get_user_display_type( $seller_id ) . '</a>';
});

wpj_add_shortcode( 'buyer_name', function( $atts = '' ) {
	$buyer_id = wpj_get_buyer_id();

	return '<a href="' . wpj_get_user_profile_link( $buyer_id ) . '">' . wpj_get_user_display_type( $buyer_id ) . '</a>';
});

wpj_add_shortcode( 'order_job_price', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_job_price', [ 'order' => '' ] );
});

wpj_add_shortcode( 'order_extra_fast_delivery_price', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order    = wpj_get_job_order_by_id( $oid );
		$multiple = $order->extra_fast > 1 ? $order->extra_fast . '&nbspx&nbsp;' : '';
		$style    = $order->extra_fast != 0 && $order->extra_fast_price ? '' : '<style>.order-efd-row-wrapper{display:none;}</style>'; // for page builder

		return $style . $multiple . '<span>' . wpj_show_price_classic( $order->extra_fast_price, 1 ) . '</span>';
	}

	return false;
});

wpj_add_shortcode( 'order_extra_revision_price', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order    = wpj_get_job_order_by_id( $oid );
		$multiple = $order->extra_revision > 1 ? $order->extra_revision . '&nbspx&nbsp;' : '';
		$style    = $order->extra_revision != 0 && $order->extra_revision_price ? '' : '<style>.order-er-row-wrapper{display:none;}</style>'; // for page builder

		return $style . $multiple . '<span>' . wpj_show_price_classic( $order->extra_revision_price, 1 ) . '</span>';
	}

	return false;
});

wpj_add_shortcode( 'order_extra_description', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order = wpj_get_job_order_by_id( $oid );

		$_atts = shortcode_atts( [ 'extra_nr' => '' ], $atts );

		if ( $order->{'extra' . $_atts['extra_nr']} != 0 )
			$extra_title = $order->{'extra' . $_atts['extra_nr'] . '_title'};

		elseif ( get_post_meta( $order->pid, 'extra' . $_atts['extra_nr'] . '_content', true ) )
			$extra_title = get_post_meta( $order->pid, 'extra' . $_atts['extra_nr'] . '_content', true );

		else
			$extra_title = '';

		$extra_title = wpj_apply_filter_to_string( $extra_title, false, 'transactionpages' );

		$style = $order->{'extra' . $_atts['extra_nr']} != 0 && $order->{'extra' . $_atts['extra_nr'] . '_price'} ? '' : '<style>.order-extra' . $_atts['extra_nr'] . '-row-wrapper{display:none;}</style>'; // for page builder

		return $style . $extra_title;

	}

	return false;
});

wpj_add_shortcode( 'order_extra_price', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order    = wpj_get_job_order_by_id( $oid );
		$_atts    = shortcode_atts( [ 'extra_nr' => '' ], $atts );
		$multiple = $order->{'extra' . $_atts['extra_nr']} > 1 ? $order->{'extra' . $_atts['extra_nr']} . '&nbspx&nbsp;' : '';

		return $multiple . '<span>' . wpj_show_price_classic( $order->{'extra' . $_atts['extra_nr'] . '_price'}, 1 ) . '</span>';
	}

	return false;
});

wpj_add_shortcode( 'order_custom_extras', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_custom_extras_list', [ 'order' => '', 'include_ul' => '', 'ul_class' => '', 'li_class' => '' ] );
});

wpj_add_shortcode( 'order_tips', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_tips_list', [ 'order' => '', 'include_ul' => '', 'ul_class' => '', 'li_class' => '' ] );
});

wpj_add_shortcode( 'order_shipping', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order = wpj_get_job_order_by_id( $oid );
		$style = get_post_meta( $order->pid, 'shipping', true ) ? '' : '<style>.order-shipping-row-wrapper{display:none;}</style>'; // for page builder

		return $style . wpj_show_price_classic( get_post_meta( $order->pid, 'shipping', true ), 1 );
	}

	return false;
});

wpj_add_shortcode( 'order_processing_fees', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order           = wpj_get_job_order_by_id( $oid );
		$processing_fees = apply_filters( 'wpj_order_processing_fees_price_filter', wpj_get_order_total_price( $order )['buyer_fee'], $order );
		$style           = $processing_fees > 0 ? '' : '<style>.order-processing-fees-row-wrapper{display:none;}</style>'; // for page builder

		return $style . wpj_show_price_classic( $processing_fees, 1 );
	}

	return false;
});

wpj_add_shortcode( 'order_tax', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order = wpj_get_job_order_by_id( $oid );
		$tax   = apply_filters( 'wpj_order_tax_price_filter', wpj_get_order_total_price( $order )['tax'], $order );
		$style = $tax > 0 ? '' : '<style>.order-tax-row-wrapper{display:none;}</style>'; // for page builder

		return $style . wpj_show_price_classic( $tax, 1 );
	}

	return false;
});

wpj_add_shortcode( 'order_total_price', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	if ( $oid ) {
		$order = wpj_get_job_order_by_id( $oid );

		return wpj_show_price_classic( apply_filters( 'wpj_order_total_price_filter', wpj_get_order_total_price( $order )['total'], $order, 'order_page' ), 1 );
	}

	return wpj_show_price_classic( '0' );
});

wpj_add_shortcode( 'order_buyer_instructions', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_buyer_instructions', ['order' => ''] );
});

wpj_add_shortcode( 'order_instant_delivery_files', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_instant_delivery_files', ['order' => ''] );
});

wpj_add_shortcode( 'order_custom_offer_description', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_custom_offer_description', ['order' => ''] );
});

wpj_add_shortcode( 'order_custom_fields', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_custom_fields', ['order' => ''] );
});

wpj_add_shortcode( 'order_date_made', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_date_made', ['order' => ''] );
});

wpj_add_shortcode( 'order_date_closed', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_date_closed', ['order' => ''] );
});

wpj_add_shortcode( 'order_payment_method', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	return '<span class="js-payment-method" data-method="' . wpj_get_job_order_by_id( $oid, 'payment_gateway' ) . '">' . wpj_translate_string( wpj_get_job_order_by_id( $oid, 'payment_gateway' ) ) . '</span>';
});

wpj_add_shortcode( 'order_cancelled_message', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	return wpj_get_order_cancellation_message( $oid, 'message' );
});

wpj_add_shortcode( 'order_cancelled_reason', function( $atts = '' ) {
	global $wp_query;

	$oid = isset( $wp_query->query_vars['oid'] ) ? esc_sql( $wp_query->query_vars['oid'] ) : '';

	return wpj_get_order_cancellation_message( $oid, 'reason' );
});

wpj_add_shortcode( 'order_notification_messages', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_notification_messages', [ 'order' => '' ] );
});

wpj_add_shortcode( 'order_action_buttons', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_action_buttons', [ 'args' => [
		'order'                 => '',
		'wrapper_class'         => 'order-header-action-buttons-wrapper',
		'buttons_wrapper_class' => 'div-end-flex',
		'buttons_only'          => true,
		'button_accept_class'   => 'text-button text-button-confirmation',
		'button_deny_class'     => 'text-button text-button-simple-on-dark',
		'button_abort_class'    => 'text-button text-button-negative',
		'button1_order'         => 2,
		'button2_order'         => 1
	] ] );
});

wpj_add_shortcode( 'order_feedback_form', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_feedback_form', [ 'order' => '' ] );
});

wpj_add_shortcode( 'order_message_form', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_order_message_form', [ 'order' => '' ] );
});