<?php /* PAYMENT */

wpj_add_shortcode( 'payment_currency_switcher',      function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_currency_selector_with_POST' );
});
wpj_add_shortcode( 'payment_instructions',           function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_payment_general_instructions' );
});
wpj_add_shortcode( 'buyer_processing_fees_percent',  function( $atts = '' ) {
	return wpj_get_option( 'wpjobster_enable_buyer_processing_fees' ) == 'percent' ? wpj_get_site_processing_fees_percent() . '%' : __( 'fixed', 'wpjobster' );
});
wpj_add_shortcode( 'buyer_processing_fees_price',    function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_buyer_processing_fees' );
});
wpj_add_shortcode( 'buyer_tax_percent',              function( $atts = '' ) {
	return wpj_get_site_tax_percent() . '%';
});
wpj_add_shortcode( 'buyer_tax_price',                function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_buyer_tax' );
});
wpj_add_shortcode( 'payment_buttons',                function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_payment_buttons', [ 'payment_type' => '', 'include_credits' => true, 'credits_only' => false ] );
});
wpj_add_shortcode( 'job_price',                      function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_job_order_price', [ 'pid' => '', 'class' => '', 'include_price_type' => true, 'package_nr' => '' ] );
});
wpj_add_shortcode( 'payment_total_price',            function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_job_order_total_price', [ 'payment_type' => '', 'package_nr' => '' ] );
});

/* USER PAYMENT */

wpj_add_shortcode( 'no_credits_warning',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_no_credits_warning' );
});
wpj_add_shortcode( 'pending_withdrawals_list',       function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_pending_withdrawals_list' );
});
wpj_add_shortcode( 'pending_incoming_payments_list', function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_pending_incoming_payments_list' );
});
wpj_add_shortcode( 'transactions_list',              function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_transactions_list' );
});
wpj_add_shortcode( 'user_sales_number',              function( $atts = '' ) {
	$_atts = shortcode_atts( [ 'uid' => '', 'order_status' => '' ], $atts );

	return '<span class="item-count">' . wpj_get_sales_orders( $_atts['uid'], $_atts['order_status'] ) . '</span>';
});
wpj_add_shortcode( 'user_sales_list',                function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_sales_list', [ 'tab' => '' ] );
});
wpj_add_shortcode( 'user_shopping_number',           function( $atts = '' ) {
	$_atts = shortcode_atts( [ 'uid' => '', 'order_status' => '' ], $atts );

	return '<span class="item-count">' . wpj_get_shopping_orders( $_atts['uid'], $_atts['order_status'] ) . '</span>';
});
wpj_add_shortcode( 'user_shopping_list',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_shopping_list', [ 'tab' => '' ] );
});