<?php /* USER */

wpj_add_shortcode( 'users_list',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_users_list', array( 'args' => $atts ) );
});
wpj_add_shortcode( 'user_description',       function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_description', [ 'uid' => '', 'pid' => '' ] );
});
wpj_add_shortcode( 'user_credit',            function( $atts = '' ) {
	return wpj_show_price( wpj_get_user_credit() );
});
wpj_add_shortcode( 'user_level',            function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_level_label', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_graph',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_graph', [ 'graph_type' => '', 'full_width' => '' ] );
});

/* SINGLE USER */

wpj_add_shortcode( 'user_cover',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_cover_image' );
});
wpj_add_shortcode( 'user_photo',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_photo', [ 'args' => $atts ] );
});
wpj_add_shortcode( 'user_avatar',            function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_avatar', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'avatar_upload_form',     function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_photo_upload_form', [ 'width' => '', 'height' => '', 'page' => '' ] );
});
wpj_add_shortcode( 'user_status',            function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_status_icon', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_name',              function( $atts = '' ) {
	return wpj_get_user_display_type( wpj_get_user_id() );
});
wpj_add_shortcode( 'user_type',              function( $atts = '' ) {
	return wpj_get_user_account_type( wpj_get_user_id() ) == 'buyer' ? __( 'Buyer', 'wpjobster' ) : __( 'Seller', 'wpjobster' );
});
wpj_add_shortcode( 'user_company',           function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_company_name', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_icons',             function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_info_icons', [ 'uid' => '', 'filter' => [ 'status' => 'no', 'country' => 'no' ], 'pid' => '' ] );
});
wpj_add_shortcode( 'user_tagline',           function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_tagline', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_rating',            function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_rating_info', [ 'uid' => '', 'pid' => '' ] );
});
wpj_add_shortcode( 'seller_reputation',      function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_seller_reputation', [ 'uid' => '', 'pid' => '' ] );
});
wpj_add_shortcode( 'user_country',           function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_country', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_distance',          function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_distance', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_registered_date',   function( $atts = '' ) {
	$user_data = get_userdata( wpj_get_user_id() );
	$reg       = isset( $user_data->user_registered ) ? $user_data->user_registered : 0;

	return strtotime( $reg ) > 0 ? wpj_date( wpj_get_option( 'date_format' ), strtotime( $reg ) ) : __( 'There is no record of the date', 'wpjobster' );
});
wpj_add_shortcode( 'user_avg_response_time', function( $atts = '' ) {
	return wpj_get_user_avg_response_time( wpj_get_user_id() );
});
wpj_add_shortcode( 'user_recent_delivery',   function( $atts = '' ) {
	return wpj_get_user_recent_delivery( wpj_get_user_id() );
});
wpj_add_shortcode( 'user_last_seen',         function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_last_seen', [ 'uid' => '', 'display_label' => false ] );
});
wpj_add_shortcode( 'user_vacation_mode',     function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_vacation_mode_button' );
});
wpj_add_shortcode( 'user_profile_link',      function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_username_as_link', [ 'uid' => '' ] );
});
wpj_add_shortcode( 'user_contact_button',    function( $atts = '' ) {
	return wpj_fnc_to_shortcode( $atts, 'wpj_display_user_contact_button', [ 'uid' => '', 'pid' => '', 'post_type' => '' ] );
});
wpj_add_shortcode( 'user_vacation_reason',   function( $atts = '' ) {
	$user_vacation_info = wpj_get_user_vacation( wpj_get_user_id() );

	return isset( $user_vacation_info['reason'] ) ? $user_vacation_info['reason'] : false;
});
wpj_add_shortcode( 'user_vacation_end_date', function( $atts = '' ) {
	$user_vacation_info = wpj_get_user_vacation( wpj_get_user_id() );

	return isset( $user_vacation_info['end'] ) ? wpj_date( wpj_get_option( 'date_format' ), $user_vacation_info['end'], false ) : false;
});