<?php
add_action( 'switch_theme', 'wpj_theme_deactivation', 10, 2 );
if ( ! function_exists( 'wpj_theme_deactivation' ) ) {
	function wpj_theme_deactivation( $theme_name, $new_theme ) {
		unset( $_GET['action'] );

		$wpj_plugins    = wpj_get_wpjobster_plugins_list();
		$active_plugins = wpj_get_option( 'active_plugins' );

		if ( $wpj_plugins && $active_plugins ) {
			$common_plugins = array_intersect( $wpj_plugins, $active_plugins );

			if ( $common_plugins ) {
				if ( ! is_a( $new_theme->parent(), '\WP_Theme' )
					&& $theme_name != 'Jobster'
					&& $theme_name != 'Jobster Child Theme'
					&& $new_theme->get( 'Author' ) != 'WPJobster'
				) {
					update_option( 'wpj_active_plugins', $common_plugins );

					include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

					deactivate_plugins( $common_plugins, true );

					foreach ( $common_plugins as $common_plugin ) {
						$plugin_arr  = explode( '/', $common_plugin );
						$plugin_name = isset( $plugin_arr[0] ) ? ucwords( str_replace( '-', ' ', $plugin_arr[0] ) ) : __( 'Unknown', 'wpjobster' );

						echo '<div class="error">';
							echo '<p>' . sprintf( __( 'The current theme is not compatible with the plugin %s. Activate the WPJobster theme before installing this plugin.', 'wpjobster' ), $plugin_name ) . '</p>';
						echo '</div>';
					}
				}
			}
		}
	}
}

add_action( 'after_switch_theme', 'wpj_theme_activation' );
if ( ! function_exists( 'wpj_theme_activation' ) ) {
	function wpj_theme_activation() {
		$wpj_active_plugins = wpj_get_option( 'wpj_active_plugins' );

		if ( $wpj_active_plugins && is_array( $wpj_active_plugins ) ) {
			foreach ( $wpj_active_plugins as $wpj_active_plugin ) {
				include_once( ABSPATH . 'wp-admin/includes/plugin.php' );

				activate_plugin( $wpj_active_plugin );
			}
		}

		/* Remove and recreate rewrite rules */
		wpj_create_post_type();
		flush_rewrite_rules();
	}
}

add_action( 'admin_init', 'wpj_theme_activation_redirect' );
if ( ! function_exists( 'wpj_theme_activation_redirect' ) ) {
	function wpj_theme_activation_redirect() {
		global $pagenow;

		if ( isset( $_GET['activated'] ) ) {
			if ( 'themes.php' == $pagenow ) {
				if ( is_admin() ) {
					if ( ! get_option( 'wpjobster_installed_date' ) ) {
						wp_redirect( esc_url_raw( add_query_arg( 'page', 'wpjobster-install', admin_url( 'themes.php' ) ) ) );
					}
				}
			}
		}
	}
}

/* Keep theme mod from parent to child */
if ( get_stylesheet() !== get_template() ) {

	add_filter( 'pre_update_option_theme_mods_' . get_stylesheet(), function ( $value, $old_value ) {
		update_option( 'theme_mods_' . get_template(), $value );

		return $old_value; // prevent update to child theme mods
	}, 10, 2 );

	add_filter( 'pre_option_theme_mods_' . get_stylesheet(), function ( $default ) {
		return get_option( 'theme_mods_' . get_template(), $default );
	});

}

add_action( 'after_switch_theme', 'wpj_deregister_footer_1_sidebar_default_widgets' );
if ( ! function_exists( 'wpj_deregister_footer_1_sidebar_default_widgets' ) ) {
	function wpj_deregister_footer_1_sidebar_default_widgets () {
		$sidebars_widgets = get_option( 'sidebars_widgets', [] );

		if ( ! empty( $sidebars_widgets['footer-widget-1'] ) ) {
			foreach ( $sidebars_widgets['footer-widget-1'] as $k => $v ) {
				if ( strpos( $v, 'block' ) !== false ) unset( $sidebars_widgets['footer-widget-1'][$k] );
			}
		}

		update_option( 'sidebars_widgets', $sidebars_widgets );
	}
}

add_action( 'after_switch_theme', 'wpj_remove_wp_default_pages' );
if ( ! function_exists( 'wpj_remove_wp_default_pages' ) ) {
	function wpj_remove_wp_default_pages () {
		$sample_page = wpj_get_page_by_title( 'Sample Page' );

		if ( isset( $sample_page->ID ) ) wp_delete_post( $sample_page->ID, true );

		$privacy_policy_page = wpj_get_page_by_title( 'Privacy Policy' );

		if ( isset( $privacy_policy_page->ID ) && $privacy_policy_page->post_status == 'draft' ) wp_delete_post( $privacy_policy_page->ID, true );
	}
}