<?php
add_action( 'init', 'wpj_flush_cookie_buster' );
if ( ! function_exists( 'wpj_flush_cookie_buster' ) ) {
	function wpj_flush_cookie_buster() {
		if ( isset( $_SERVER['HTTP_COOKIE'] ) && isset( $_GET['flush_cookies'] ) ) {
			$cookies = explode( ';', $_SERVER['HTTP_COOKIE'] );

			foreach ( $cookies as $cookie ) {
				$parts = explode( '=', $cookie );
				$name  = trim( $parts[0] );

				setcookie( $name, '', time() - 1000 );
				setcookie( $name, '', time() - 1000, '/' );
			}

		}
	}
}

add_action( 'wp', 'wpj_set_template_url_cookie' );
if ( ! function_exists( 'wpj_set_template_url_cookie' ) ) {
	function wpj_set_template_url_cookie() {
		ob_start();

		if ( ! isset( $_COOKIE['template_url'] ) ) {
			setcookie( 'template_url', get_template_directory_uri(), time() + 86400, '/' );
		}

		if ( ! isset( $_COOKIE['relative_template_path'] ) ) {
			setcookie( 'relative_template_path', str_replace( content_url(), '../..', get_template_directory_uri() ), time() + 86400, '/' );
		}

		ob_end_flush();
	}
}