<?php
add_action( 'wp_head', 'wpj_header_meta_info' );
if ( ! function_exists( 'wpj_header_meta_info' ) ) {
	function wpj_header_meta_info() {
		global $wp_query, $is_profile_pg;

		$jobster_design = wpj_get_design_option(); ?>

		<meta name="jobster-license" content="<?php echo wpj_get_license_name(); ?>" />

		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />

		<?php if ( is_singular( 'job' ) ) {
			$job_image_url = get_the_post_thumbnail_url( get_the_ID(), 'job_slider_image' );

			if ( ! $job_image_url ) {
				$job_image_url = ! empty( $jobster_design['no_image_icon_options_job']['url'] ) ? $jobster_design['no_image_icon_options_job']['url'] : get_template_directory_uri() . '/assets/images/dummy/placeholder.webp';
				$job_image_url = apply_filters( 'wpj_placeholder_image_url_filter', $job_image_url, 'jobs' );
			} ?>

			<meta name="twitter:image" content="<?php echo $job_image_url; ?>" />
			<meta property="og:image" content="<?php echo $job_image_url; ?>" />
			<meta property="og:image:width" content="720" />
			<meta property="og:image:height" content="405" />

		<?php }

		if ( $is_profile_pg ) {
			$username    = urldecode( $wp_query->query_vars['username'] );
			$user_object = get_user_by( 'login', $username );
			$user_avatar = wpj_get_avatar( $user_object->ID, 180, 180 ); ?>

			<meta name="twitter:image" content="<?php echo $user_avatar; ?>" />
			<meta property="og:image" content="<?php echo $user_avatar; ?>" />
			<meta property="og:image:width" content="180" />
			<meta property="og:image:height" content="180" />

		<?php }
	}
}