<?php
function wpj_loop_check() {
	$esnecil_yek = wpj_get_option( 'emos_laer_euqinu_eman' );

	if ( in_array( $GLOBALS['pagenow'], [ 'wp-login.php', 'wp-register.php' ] ) ) {
		return 1;
	}

	if ( ! isset( $esnecil_yek ) || $esnecil_yek == '' ) {
		return false;
	}

	$uz_dellatsni_niamod = wpj_get_host_without_www();
	$uz_terces_edoc      = 'd945jfht';

	if (
		$esnecil_yek == hash( "sha256", $uz_dellatsni_niamod . $uz_terces_edoc . '3' , false )
		|| $esnecil_yek == hash( "sha256", wpj_get_host() . $uz_terces_edoc . '3' , false )
	) {
		return 3;

	} elseif (
		$esnecil_yek == hash( "sha256", $uz_dellatsni_niamod . $uz_terces_edoc . '2' , false )
		|| $esnecil_yek == hash( "sha256", wpj_get_host() . $uz_terces_edoc . '2' , false )
	) {
		return 2;

	} elseif (
		$esnecil_yek == hash( "sha256", $uz_dellatsni_niamod . $uz_terces_edoc . '1' , false )
		|| $esnecil_yek == hash( "sha256", wpj_get_host() . $uz_terces_edoc . '1' , false )
	) {
		return 1;

	} elseif (
		$esnecil_yek == hash( "sha256", $uz_dellatsni_niamod . $uz_terces_edoc , false )
		|| $esnecil_yek == hash( "sha256", wpj_get_host() . $uz_terces_edoc , false )
	) {
		return 1;

	} elseif (
		$esnecil_yek == hash( "sha256", $uz_dellatsni_niamod . $uz_terces_edoc . '0.5' , false )
		|| $esnecil_yek == hash( "sha256", wpj_get_host() . $uz_terces_edoc . '0.5' , false )
	) {
		return 0.5;

	}

	return false;
}

function wpj_get_license_name() {
	if ( wpj_loop_check() == 3 ) {
		return 'Entrepreneur';

	} elseif ( wpj_loop_check() == 2 ) {
		return 'Developer';

	} elseif ( wpj_loop_check() == 1 ) {
		return 'Webmaster';

	} elseif ( wpj_loop_check() == 0.5 ) {
		return 'Beginner';

	} else {
		return 'None';

	}
}

function wpj_get_min_lcs_for( $feature ) {
	if (
		in_array( $feature, [
			'top_up',
			'subscriptions',
			'sms_notifications',
			'packages',
		] )
	) {
		return 3;

	} elseif (
		in_array( $feature, [
			'processing_fee',
			'multi_language',
		] )
	) {
		return 2;

	} elseif (
		in_array( $feature, [
			'multi_currency',
			'featured_job',
			'custom_offers',
			'flexible_fees',
			'job_multiples',
			'custom_extras',
			'fast_del_multiples',
		] )
	) {
		return 1;
	}

	return 0;
}

function wpj_disabled_settings_class( $feature ) {
	if ( ! wpj_is_allowed( $feature ) ) {
		echo 'wpjobster-disabled-settings';
	}
}


function wpj_disabled_settings_error( $feature ) {
	$the_loop_check   = wpj_loop_check();
	$min_lcs_for_this = wpj_get_min_lcs_for( $feature );

	if ( $min_lcs_for_this == 1 ) {
		$available_for_txt = 'Webmaster, Developer or Entrepreneur';

	} elseif ( $min_lcs_for_this == 2 ) {
		$available_for_txt = 'Developer or Entrepreneur';

	} elseif ( $min_lcs_for_this == 3 ) {
		$available_for_txt = 'Entrepreneur';

	} else {
		return;

	}

	if ( $the_loop_check < $min_lcs_for_this ) { ?>

		<div class="error notice">
			<p>Some settings could not be saved. Please <a href="https://wpjobster.com/buy/?utm_source=upgrade-feature-notice" target="_blank">upgrade</a> your license to <?php echo $available_for_txt; ?> in order to use this feature.</p>
		</div>

	<?php }
}

function wpj_disabled_settings_notice( $feature ) {
	$the_loop_check   = wpj_loop_check();
	$min_lcs_for_this = wpj_get_min_lcs_for( $feature );

	if ( $min_lcs_for_this == 1 ) {
		$available_for_txt = 'This feature is only available for the Webmaster, Developer and Entrepreneur licenses.';

	} elseif ( $min_lcs_for_this == 2 ) {
		$available_for_txt = 'This feature is only available for the Developer and Entrepreneur licenses.';

	} elseif ( $min_lcs_for_this == 3 ) {
		$available_for_txt = 'This feature is only available for the Entrepreneur license.';

	} else {
		return;

	}

	if ( $the_loop_check < $min_lcs_for_this ) { ?>

		<div class="wpjobster-update-nag wpjobster-notice">
			<?php echo $available_for_txt; ?> <a href="http://wpjobster.com/features/" target="_blank">Learn more</a> about the features, <a href="https://wpjobster.com/buy/?utm_source=upgrade-feature-notice" target="_blank">buy</a> a new license or <a href="http://wpjobster.com/contact/" target="_blank">contact us</a> for upgrading.
		</div>

	<?php }
}

function wpj_is_allowed( $feature ) {
	if ( wpj_loop_check() >= wpj_get_min_lcs_for( $feature ) ) {
		return true;
	}

	return false;
}

function wpj_is_processing_fee_allowed() {
	return wpj_is_allowed( 'processing_fee' );
}

function wpj_is_topup_allowed() {
	return wpj_is_allowed( 'top_up' );
}

function wpj_is_subscription_allowed() {
	return wpj_is_allowed( 'subscriptions' );
}

function wpj_is_multilanguage_allowed() {
	return wpj_is_allowed( 'multi_language' );
}