<?php
add_action( 'admin_enqueue_scripts', 'wpj_localize_vars', 11 );
add_action( 'wp_enqueue_scripts', 'wpj_localize_vars', 11 );
if ( ! function_exists( 'wpj_localize_vars' ) ) {
	function wpj_localize_vars() {
		/* OPTIONS */
		$jobster_settings = get_option( 'jobster_settings' );
		$jobster_design   = get_option( 'jobster_design' );

		if ( ! $jobster_settings || ! $jobster_design ) {
			return false;
		}

// FRONT
		$front_strings = [];

		/* WP */
		$front_strings += [
			'is_in_app'      => wpj_is_handheld() && wpj_is_iframe_previous_pageload() !== false,
			'language_code'  => substr( get_bloginfo ( 'language' ), 0, 2 ),
			'page_name'      => get_query_var( 'pagename' ),
			'posts_per_page' => get_option( 'posts_per_page', 12 ),
			'starting_day'   => get_option( 'start_of_week', 1 ),
			'url_params'     => $_SERVER['QUERY_STRING'],
			'page_url'       => ( is_ssl() ? 'https://' : 'http://' ) . $_SERVER['HTTP_HOST'] . strtok( $_SERVER["REQUEST_URI"], '?' ),
			'parent_url'     => get_permalink()
		];

		/* FRONT - NOT LOGGED IN */
		if ( ! is_user_logged_in() ) {
			$front_strings += [
				'is_login_page'          => $GLOBALS['pagenow'] == 'wp-login.php' && ( ! WPJ_Form::get( 'action' ) || WPJ_Form::get( 'action' ) == 'login' ),
				'is_register_page'       => $GLOBALS['pagenow'] == 'wp-login.php' && WPJ_Form::get( 'action' ) == 'register',
				'is_lost_password_page'  => $GLOBALS['pagenow'] == 'wp-login.php' && WPJ_Form::get( 'action' ) == 'lostpassword',
				'auth_login_url'         => get_permalink( $jobster_settings['wpjobster_login_page_id'] ),
				'auth_register_url'      => get_permalink( $jobster_settings['wpjobster_register_page_id'] ),
				'auth_lostpassword_url'  => get_permalink( $jobster_settings['wpjobster_forgot_password_page_id'] ),
				'reCaptcha_api_key'      => $jobster_settings['wpjobster_recaptcha_api_key'] ?? '',
				'phone_number_mandatory' => $jobster_settings['wpjobster_phone_number_mandatory']
			];
		}

		/* PAGE TRANSITION */
		$front_strings += [
			'load_more_type' => $jobster_settings['wpj_posts_load_type'],
			'page_transition' => ! empty( $jobster_design['site_page_transition'] ) ? $jobster_design['site_page_transition'] : 'regular',
		];

		if ( ! empty( $jobster_design['site_page_transition'] ) && $jobster_design['site_page_transition'] != 'regular' ) {
			$front_strings['page_transition_effect']    = ! empty( $jobster_design['site_page_transition_effect'] ) ? $jobster_design['site_page_transition_effect'] : 'fade';
			$front_strings['page_transition_direction'] = ! empty( $jobster_design['site_page_transition_effect_direction'] ) ? $jobster_design['site_page_transition_effect_direction'] : 'down';
			$front_strings['page_transition_colour']    = ! empty( $jobster_design['site_page_transition_effect_color'] ) ? $jobster_design['site_page_transition_effect_color'] : '#20c497';
		}

		/* THEME URLs */
		$homepage_logged_in_id   = apply_filters( 'wpj_main_page_url_user_filter', wpj_get_option( 'main_page_url_user' ) );
		$homepage_logged_in_url  = rtrim( get_permalink( $homepage_logged_in_id ), '/' );
		$homepage_logged_in_slug = get_post_field( 'post_name', $homepage_logged_in_id );

		$front_strings += [
			'checkout_url'        => get_permalink( $jobster_settings['wpjobster_checkout_page_id'] ),
			'home_loggedin_url'   => $homepage_logged_in_url . ( $homepage_logged_in_url == get_bloginfo( 'url' ) ? '/' . $homepage_logged_in_slug : '' ),
			'light_ajax_url'      => get_template_directory_uri() . '/includes/light-ajax.php',
			'my_account_url'      => get_permalink( $jobster_settings['wpjobster_my_account_page_id'] ),
			'my_requests_url'     => get_permalink( $jobster_settings['wpjobster_my_requests_page_id'] ),
			'pm_url'              => wpj_get_pm_link(),
			'search_jobs_url'     => get_permalink( $jobster_settings['wpjobster_advanced_search_id'] ),
			'search_requests_url' => get_permalink( $jobster_settings['wpjobster_advanced_search_request_page_id'] ),
			'search_users_url'    => get_permalink( $jobster_settings['wpjobster_search_user_page_id'] ),
			'user_profile_url'    => wpj_get_user_profile_link()
		];

		/* THEME PAGE IDs */
		$front_strings += [
			'page_on_front_page_id' => get_option( 'page_on_front' ),
			'my_account_page_id'    => $jobster_settings['wpjobster_my_account_page_id'],
			'my_sales_page_id'      => $jobster_settings['wpjobster_my_account_sales_page_id'],
			'my_payments_page_id'   => $jobster_settings['wpjobster_my_account_payments_page_id'],
			'order_page_id'         => $jobster_settings['wpjobster_order_page_id'],
			'topup_order_page_id'   => $jobster_settings['wpjobster_topup_order_page_id'],
			'new_request_page_id'   => $jobster_settings['wpjobster_new_request_page_id'],
			'new_job_page_id'       => $jobster_settings['wpjobster_post_new_page_id'],
			'user_settings_page_id' => $jobster_settings['wpjobster_my_account_personal_info_page_id'],
			'proposal_page_id'      => $jobster_settings['wpjobster_all_proposals_page_id'],
			'user_profile_page_id'  => $jobster_settings['wpjobster_user_profile_page_id'],
			'badge_page_id'         => $jobster_settings['wpjobster_badges_page_id'],
			'subscription_page_id'  => $jobster_settings['wpjobster_subscriptions_page_id'],
			'featured_page_id'      => $jobster_settings['wpjobster_feature_page_id'],
			'checkout_page_id'      => $jobster_settings['wpjobster_checkout_page_id'],
			'login_page_id'         => $jobster_settings['wpjobster_login_page_id'],
			'register_page_id'      => $jobster_settings['wpjobster_register_page_id'],
			'lost_password_page_id' => $jobster_settings['wpjobster_forgot_password_page_id']
		];

		/* HEADER */
		$front_strings += [
			'long_menu_arrows' => ! empty( $jobster_design['enable_long_menu_arrows'] ) ? $jobster_design['enable_long_menu_arrows'] : false,
			'header_style'     => ! empty( $jobster_design['header_style'] ) ? $jobster_design['header_style'] : 'fixed_top'
		];

		/* LOCATION */
		$front_strings += [
			'tomtom_api_key'    => $jobster_settings['wpjobster_tomtom_search_api_key'] ?? '',
			'locations_api_key' => $jobster_settings['wpjobster_google_maps_api_key'] ?? '',
			'locations_api'     => $jobster_settings['wpjobster_location_api_provider'],
			'locations_country' => ! empty( $jobster_settings['wpjobster_location_restrict_country'] ) ? array_map( 'trim', explode( ',', $jobster_settings['wpjobster_location_restrict_country'] ) ) : [],
			'locations_types'   => array_map( 'trim', [$jobster_settings['wpjobster_location_restrict_type']] ),
			'location_fields'   => ! empty( $jobster_settings['wpjobster_location_fields'] ) ? json_encode( array_map( 'trim', explode( ',', $jobster_settings['wpjobster_location_fields'] ) ) ) : '',
			'html5_geolocation' => $jobster_settings['wpjobster_html5_geolocation_enable']
		];

		/* NOTIFY */
		$front_strings += [
			'ligh_ajax_enabled'         => isset( $jobster_design['enable_light_ajax'] ) && $jobster_design['enable_light_ajax'] == 1,
			'pm_emoji_enabled'          => $jobster_settings['wpjobster_pm_emoji_enable'],
			'chat_emoji_enabled'        => $jobster_settings['wpjobster_chat_emoji_enable'],
			'transaction_emoji_enabled' => $jobster_settings['wpjobster_transaction_emoji_enable'],
			'chat_enabled'              => $jobster_settings['wpjobster_chat_enable'],
			'quick_responses'           => get_user_meta( get_current_user_id(), 'quick_responses', true ),
			'resend_sms_time'           => $jobster_settings['wpj_resend_sms_time'] > 0 ? $jobster_settings['wpj_resend_sms_time'] : 0,
			'enable_scroll_down_button' => isset( $jobster_design['messages_scroll_down_enable'] ) ? $jobster_design['messages_scroll_down_enable'] : true,
			'characters_pm_min'         => wpj_get_characters_limit( 'private_message', 'min', 0 ),
			'characters_pm_max'         => wpj_get_characters_limit( 'private_message', 'max', 1200 ),
			'pm_min_content'            => sprintf( __( 'The message needs to have at least %d characters', 'wpjobster' ), wpj_get_characters_limit( 'private_message', 'min', 0 ) ),
			'pm_max_content'            => sprintf( __( 'The message needs to have at most %d characters', 'wpjobster' ), wpj_get_characters_limit( 'private_message', 'max', 1200 ) )
		];

		/* SEARCH */
		$front_strings += [
			'allow_job'     => $jobster_settings['wpjobster_enable_jobs_for_advanced_search'],
			'allow_request' => $jobster_settings['wpjobster_enable_requests_for_advanced_search'],
			'allow_users'   => $jobster_settings['wpjobster_enable_users_for_advanced_search']
		];

		/* JOB - CHECKOUT */
		if ( is_page( $jobster_settings['wpjobster_checkout_page_id'] ) ) {
			$front_strings += [
				'extra_prch_page' => $jobster_settings['wpjobster_checkout_extra_enabled'],
				'force_allow'     => apply_filters( 'wpj_force_allow_filter', false )
			];
		}

		/* JOB - SINGLE */
		if ( is_singular( 'job' ) ) {
			$front_strings += [
				'featured_enable' => $jobster_settings['wpjobster_featured_enable']
			];
		}

		/* JOB - POST NEW */
		if ( is_page( $jobster_settings['wpjobster_post_new_page_id'] ) ) {
			$JobsNewEditClass = new WPJJobsNewEdit();

			$pck_vars   = wpj_get_packages_custom_fields();
			$extra_vars = $JobsNewEditClass->getExtrasInfo();

			$front_strings += $JobsNewEditClass->getJobValidationStrings();

			$front_strings += [
				'enable_extra'                           => wpj_get_user_feature_status( 'wpjobster_enable_extra', 'wpjobster_subscription_noof_extras_enabled' ),
				'extra_multiples'                        => wpj_get_user_feature_value( 'extras', 'noof_extras', 10 ),
				'video_multiples'                        => wpj_get_user_feature_value( 'vds', 'video_multiples', 1 ),
				'amount_jobprice_min'                    => wpj_get_user_feature_value( 'min_amount', 'min_job_price' ),
				'amount_jobprice_max'                    => wpj_get_user_feature_value( 'max_amount', 'max_job_price' ),
				'amount_job_package_price_min'           => $jobster_settings['wpj_package_amount_price_limits'][1] ?? 5,
				'amount_job_package_price_max'           => $jobster_settings['wpj_package_amount_price_limits'][2] ?? 1000,
				'amount_jobextra_price_min'              => wpj_get_user_feature_value( 'min_extra_amount', 'min_extra_price' ),
				'amount_jobextra_price_max'              => wpj_get_user_feature_value( 'max_extra_amount', 'max_extra_price' ),
				'max_days_enabled'                       => $jobster_settings['wpjobster_enable_delivery_time'] ?? '',
				'op_enable_shipping'                     => $jobster_settings['wpjobster_enable_shipping'] ?? '',
				'op_mandatory_job_image'                 => $jobster_settings['wpjobster_mandatory_pics_for_jbs'] ?? '',
				'op_mandatory_job_audio'                 => $jobster_settings['wpjobster_mandatory_audio_for_jbs'] ?? '',
				'op_enable_audio'                        => $jobster_settings['wpjobster_audio'] ?? '',
				'op_enable_tos'                          => $jobster_settings['wpjobster_tos_type'] ?? '',
				'op_enable_job_instructions_responsive'  => $jobster_settings['wpjobster_job_instructions_responsive_enabled'] ?? '',
				'total_jobs_count'                       => wpj_get_site_jobs_count(),
				'no_days_price_types'                    => json_encode( wpj_get_job_no_days_price_types() ),
				'extra_enable'                           => ! empty( $extra_vars ) ? json_encode( $extra_vars['extra_enable'] ) : '',
				'extra_description'                      => ! empty( $extra_vars ) ? json_encode( $extra_vars['extra_description'] ) : '',
				'extra_price'                            => ! empty( $extra_vars ) ? json_encode( $extra_vars['extra_price'] ) : '',
				'extra_max_days'                         => ! empty( $extra_vars ) ? json_encode( $extra_vars['extra_max_days'] ) : '',
				'extra_multiple'                         => ! empty( $extra_vars ) ? json_encode( $extra_vars['extra_multiple'] ) : '',
				'rej_comment'                            => ! empty( $extra_vars ) ? json_encode( $extra_vars['rej_comment'] ) : '',
				'pck_cf_name'                            => ! empty( $pck_vars ) ? json_encode( $pck_vars['pck_cf_name'] ) : '',
				'pck_cf_basic'                           => ! empty( $pck_vars ) ? json_encode( $pck_vars['pck_cf_basic'] ) : '',
				'pck_cf_standard'                        => ! empty( $pck_vars ) ? json_encode( $pck_vars['pck_cf_standard'] ) : '',
				'pck_cf_premium'                         => ! empty( $pck_vars ) ? json_encode( $pck_vars['pck_cf_premium'] ) : '',
				'characters_job_title_min'               => wpj_get_characters_limit( 'job_title', 'min', 15 ),
				'characters_job_title_max'               => wpj_get_characters_limit( 'job_title', 'max', 80 ),
				'characters_job_desc_min'                => wpj_get_characters_limit( 'job_description', 'min', 0 ),
				'characters_job_desc_max'                => wpj_get_characters_limit( 'job_description', 'max', 1000 ),
				'characters_job_instr_min'               => wpj_get_characters_limit( 'job_instructions', 'min', 0 ),
				'characters_job_instr_max'               => wpj_get_characters_limit( 'job_instructions', 'max', 350 ),
				'characters_extradesc_min'               => wpj_get_characters_limit( 'job_extra_description', 'min', 0 ),
				'characters_extradesc_max'               => wpj_get_characters_limit( 'job_extra_description', 'max', 50 ),
				'characters_job_package_title_min'       => wpj_get_characters_limit( 'job_package_title', 'min', 0 ),
				'characters_job_package_title_max'       => wpj_get_characters_limit( 'job_package_title', 'max', 120 ),
				'characters_job_package_description_min' => wpj_get_characters_limit( 'job_package_description', 'min', 0 ),
				'characters_job_package_description_max' => wpj_get_characters_limit( 'job_package_description', 'max', 1000 ),
				'active_jobs_exceeded'                   => sprintf( __( 'You are not allowed to post a new job because you have reached the maximum number of jobs (%d) you are allowed to post.', 'wpjobster' ), wpj_get_user_feature_value( 'active_jobs', 'active_jobs' ) )
			];
		}

		/* USER */
		$user_credit           = wpj_get_user_credit( get_current_user_id() );
		$user_credit_formatted = wpj_show_price( $user_credit );

		$front_strings += [
			'user_credits'          => $user_credit,
			'account_balance'       => wpj_is_translatepress_preview() ? sprintf( __( 'Account Balance - %%s', 'wpjobster' ), $user_credit_formatted ) : sprintf( __( 'Account Balance - %s', 'wpjobster' ), $user_credit_formatted ),
			'desc_content'          => get_user_meta( get_current_user_id(), 'description', true ),
			'allow_video_portfolio' => $jobster_settings['wpjobster_enable_portfolio_video_upload']
		];

		/* REQUEST - POST NEW */
		if ( is_page( $jobster_settings['wpjobster_new_request_page_id'] ) ) {
			$front_strings += [
				'request_multiple'                          => $jobster_settings['wpjobster_display_request_multiple_categories'],
				'characters_request_title_min'              => wpj_get_characters_limit( 'request_title', 'min', 0 ),
				'characters_request_title_max'              => wpj_get_characters_limit( 'request_title', 'max', 80 ),
				'characters_request_desc_min'               => wpj_get_characters_limit( 'request_description', 'min', 0 ),
				'characters_request_desc_max'               => wpj_get_characters_limit( 'request_description', 'max', 1000 ),
				'lbl_request_title_min'                     => sprintf( __( 'The title field needs to have at least %d characters', 'wpjobster' ), wpj_get_characters_limit( 'request_title', 'min', 0 ) ),
				'lbl_request_title_max'                     => sprintf( __( 'The title field needs to have at most %d characters', 'wpjobster' ), wpj_get_characters_limit( 'request_title', 'max', 80 ) ),
				'lbl_request_description_min'               => sprintf( __( 'The description field needs to have at least %d characters', 'wpjobster' ), wpj_get_characters_limit( 'request_description', 'min', 0 ) ),
				'lbl_request_description_max'               => sprintf( __( 'The description field needs to have at most %d characters', 'wpjobster' ), wpj_get_characters_limit( 'request_description', 'max', 1000 ) ),
				'op_enable_request_instructions_responsive' => wpj_get_option( 'wpjobster_request_instructions_responsive_enabled' ),
			];
		}

		/* FEATURE */
		if ( is_page( $jobster_settings['wpjobster_feature_page_id'] ) ) {
			$pid = wpj_get_post_id();

			$front_strings += [
				'h_date_start' => ! empty( $jobster_settings['wpjobster_feature_page_id'] ) ? wpj_get_featured_start_date( 'homepage', $pid ) : '',
				'c_date_start' => ! empty( $jobster_settings['wpjobster_feature_page_id'] ) ? wpj_get_featured_start_date( 'category', $pid ) : '',
				's_date_start' => ! empty( $jobster_settings['wpjobster_feature_page_id'] ) ? wpj_get_featured_start_date( 'subcategory', $pid ) : ''
			];
		}

		/* ORDER */
		if ( is_page( $jobster_settings['wpjobster_order_page_id'] ) ) {
			$front_strings += [
				'order_expected_delivery' => wpj_get_order_expected_time( get_query_var( 'oid' ) ),
				'characters_feedback_min' => wpj_get_characters_limit( 'feedback_message', 'min', 0 ),
				'characters_feedback_max' => wpj_get_characters_limit( 'feedback_message', 'max', 1000 ),
				'feedback_min_desc'       => sprintf( __( 'The description field needs to have at least %d characters', 'wpjobster' ), wpj_get_characters_limit( 'feedback_message', 'min', 0 ) ),
				'feedback_max_desc'       => sprintf( __( 'The description field needs to have at most %d characters', 'wpjobster' ), wpj_get_characters_limit( 'feedback_message', 'max', 1000 ) )
			];
		}

		/* DISCOUNT */
		if ( isset( $jobster_settings['wpjobster_discounts_enable'] ) && $jobster_settings['wpjobster_discounts_enable'] == 1 ) {
			if ( is_singular( 'job' )
				|| ( $jobster_settings['wpjobster_purchase_this_discounts_enable'] == 1 && is_page( $jobster_settings['wpjobster_checkout_page_id'] ) )
			) {
				$front_strings += [
					'enable_site_fee'           => $jobster_settings['wpjobster_enable_site_fee'],
					'percent_fee_taken'         => $jobster_settings['wpjobster_percent_fee_taken'],
					'solid_fee_taken'           => $jobster_settings['wpjobster_solid_fee_taken'],
					'subscription_enabled'      => $jobster_settings['wpjobster_subscription_enabled'],
					'subscription_fees_enabled' => $jobster_settings['wpjobster_fees_for_subscriber_enabled'],
					'subscription_fee'          => wpj_get_subscription_info( get_current_user_id(), 'wpjobster_subscription_fees' )
				];
			}
		}

		/* MEDIA */
		$front_strings += [
			'message_filesize_max'  => wpj_get_media_max_upload_size( 'message' ),
			'message_pics_nr_max'   => $jobster_settings['wpjobster_message_default_nr_of_pics'] ? $jobster_settings['wpjobster_message_default_nr_of_pics'] : 5,
			'lazy_loading_enabled'  => isset( $jobster_design['enable_lazy_loading'] ) && $jobster_design['enable_lazy_loading'] == '0' ? false : true,
			'wysiwyg_enabled'       => $jobster_settings['wpjobster_wysiwyg_for_profile'],
			'max_files_per_reply'   => function_exists( 'aiosc_get_settings' ) && aiosc_get_settings( 'max_files_per_reply' ) > 0 ? aiosc_get_settings( 'max_files_per_reply' ) : 4
		];

		/* CALENDAR */
		$front_strings += [
			'days' => [
				'sun' => _x( 'S', 'Abbreviation of: Sunday', 'wpjobster' ),
				'mon' => _x( 'M', 'Abbreviation of: Monday', 'wpjobster' ),
				'tue' => _x( 'T', 'Abbreviation of: Tuesday', 'wpjobster' ),
				'wed' => _x( 'W', 'Abbreviation of: Wednesday', 'wpjobster' ),
				'thu' => _x( 'T', 'Abbreviation of: Thursday', 'wpjobster' ),
				'fri' => _x( 'F', 'Abbreviation of: Friday', 'wpjobster' ),
				'sat' => _x( 'S', 'Abbreviation of: Saturday', 'wpjobster' ),
			],
			'monthsShort' => [
				'jan' => _x( 'Jan', 'Abbreviation of: January', 'wpjobster' ),
				'feb' => _x( 'Feb', 'Abbreviation of: February', 'wpjobster' ),
				'mar' => _x( 'Mar', 'Abbreviation of: March', 'wpjobster' ),
				'apr' => _x( 'Apr', 'Abbreviation of: April', 'wpjobster' ),
				'may' => _x( 'May', 'Abbreviation of: May', 'wpjobster' ),
				'jun' => _x( 'Jun', 'Abbreviation of: June', 'wpjobster' ),
				'jul' => _x( 'Jul', 'Abbreviation of: July', 'wpjobster' ),
				'aug' => _x( 'Aug', 'Abbreviation of: August', 'wpjobster' ),
				'sep' => _x( 'Sep', 'Abbreviation of: September', 'wpjobster' ),
				'oct' => _x( 'Oct', 'Abbreviation of: October', 'wpjobster' ),
				'nov' => _x( 'Nov', 'Abbreviation of: November', 'wpjobster' ),
				'dec' => _x( 'Dec', 'Abbreviation of: December', 'wpjobster' ),
			],
			'months' => [
				'jan' => _x( 'January', 'Full name of: January', 'wpjobster' ),
				'feb' => _x( 'February', 'Full name of: February', 'wpjobster' ),
				'mar' => _x( 'March', 'Full name of: March', 'wpjobster' ),
				'apr' => _x( 'April', 'Full name of: April', 'wpjobster' ),
				'may' => _x( 'May', 'Full name of: May', 'wpjobster' ),
				'jun' => _x( 'June', 'Full name of: June', 'wpjobster' ),
				'jul' => _x( 'July', 'Full name of: July', 'wpjobster' ),
				'aug' => _x( 'August', 'Full name of: August', 'wpjobster' ),
				'sep' => _x( 'September', 'Full name of: September', 'wpjobster' ),
				'oct' => _x( 'October', 'Full name of: October', 'wpjobster' ),
				'nov' => _x( 'November', 'Full name of: November', 'wpjobster' ),
				'dec' => _x( 'December', 'Full name of: December', 'wpjobster' ),
			]
		];

		/* AUTHENTICATION */
		$front_strings += [
			'login'              => addslashes( __( 'Login', 'wpjobster' ) ),
			'loggingin'          => addslashes( __( 'Logging in...', 'wpjobster' ) ),
			'register'           => addslashes( __( 'Register', 'wpjobster' ) ),
			'forgot'             => addslashes( __( 'Forgot Password', 'wpjobster' ) ),
			'reset'              => addslashes( __( 'Reset Password', 'wpjobster' ) ),
			'user_name'          => addslashes( __( 'Username', 'wpjobster' ) ),
			'user_email'         => addslashes( __( 'Username / Email Address', 'wpjobster' ) ),
			'email'              => addslashes( __( 'Email', 'wpjobster' ) ),
			'password'           => addslashes( __( 'Password', 'wpjobster' ) ),
			'confirm_password'   => addslashes( __( 'Confirm Password', 'wpjobster' ) ),
			'new_password'       => addslashes( __( 'New Password', 'wpjobster' ) ),
			'phone_number'       => addslashes( __( 'Phone Number', 'wpjobster' ) ),
			'company'            => addslashes( __( 'Company', 'wpjobster' ) ),
			'two_fa'             => addslashes( __( '2-Step Verification Code', 'wpjobster' ) ),
			'empty_user_name'    => addslashes( __( 'Empty Username', 'wpjobster' ) ),
			'empty_email'        => addslashes( __( 'Empty Email', 'wpjobster' ) ),
			'empty_password'     => addslashes( __( 'Empty Password', 'wpjobster' ) ),
			'empty_phone_number' => addslashes( __( 'Empty Phone Number', 'wpjobster' ) ),
			'empty_recaptcha'    => addslashes( __( 'Please verify the captcha.', 'wpjobster' ) ),
			'empty_two_fa'       => addslashes( __( 'Empty 2-Step Verification Code', 'wpjobster' ) ),
			'pwd_not_match'      => addslashes( __( 'Passwords do not match.', 'wpjobster' ) ),
			'tos_not_checked'    => addslashes( __( 'You must agree to the terms and conditions.', 'wpjobster' ) )
		];

		/* STRINGS */
		$front_strings += [
			'accepted'                      => __( 'Accepted', 'wpjobster' ),
			'add_lbl'                       => __( 'Add', 'wpjobster' ),
			'add_new_lbl'                   => __( 'Add New', 'wpjobster' ),
			'add_quick_response'            => __( 'Create a new quick response', 'wpjobster' ),
			'am'                            => __( 'AM', 'wpjobster' ),
			'badge_empty'                   => __( 'Please select at least one badge.', 'wpjobster' ),
			'cancel_lbl'                    => __( 'Cancel', 'wpjobster' ),
			'check_all_email'               => __( 'Check all', 'wpjobster' ),
			'check_all_sms'                 => __( 'Check all', 'wpjobster' ),
			'continue'                      => _x( 'Continue', 'Authentication button name', 'wpjobster' ),
			'copied'                        => __( 'Copied!', 'wpjobster' ),
			'declined'                      => __( 'Declined', 'wpjobster' ),
			'delete_lbl'                    => __( 'Delete', 'wpjobster' ),
			'edit_lbl'                      => __( 'Edit', 'wpjobster' ),
			'edit_quick_response'           => __( 'Edit quick response', 'wpjobster' ),
			'email_send_lbl'                => __( 'Email sent', 'wpjobster' ),
			'empty_quick_response'          => __( 'You must enter a name and a quick response', 'wpjobster' ),
			'err_already_in_vacation'       => __( 'You already have vacation mode active.', 'wpjobster' ),
			'err_empty_start_date'          => __( 'Please select the start date.', 'wpjobster' ),
			'err_small_start_date'          => __( 'You can\'t select a date from the past.', 'wpjobster' ),
			'err_empty_end_date'            => __( 'Please select the end date.', 'wpjobster' ),
			'err_small_end_date'            => __( 'Please select a date in the future.', 'wpjobster' ),
			'err_something_wrong'           => __( 'Something went wrong.', 'wpjobster' ),
			'err_try_again'                 => __( 'Try again', 'wpjobster' ),
			'err_try_again_later'           => __( 'Please try again later.', 'wpjobster' ),
			'err_unknown'                   => __( 'Unknown error', 'wpjobster' ),
			'featured_empty'                => __( 'Please select at least one page.', 'wpjobster' ),
			'featured_interval'             => __( 'The interval was changed in the meantime.', 'wpjobster' ),
			'feedback_min'                  => __( 'Please insert a longer description for your rating', 'wpjobster' ),
			'feedback_max'                  => __( 'Please insert a shorter description for your rating', 'wpjobster' ),
			'feedback_stars'                => __( 'Please select the amount of stars', 'wpjobster' ),
			'get_for_free'                  => __( 'Get for free', 'wpjobster' ),
			'insert_faq'                    => __( 'Insert your question and answer', 'wpjobster' ),
			'jobs_label'                    => __( 'Jobs', 'wpjobster' ),
			'language_lbl'                  => __( 'Language', 'wpjobster' ),
			'lbl_please_select'             => __( 'Please Select', 'wpjobster' ),
			'lbl_request_budget'            => __( 'Budget from is equal or higher than budget to!', 'wpjobster' ),
			'lbl_request_category'          => __( 'Please select a category!', 'wpjobster' ),
			'lbl_request_date'              => __( 'Start date is higher than end date!', 'wpjobster' ),
			'lbl_request_deadline'          => __( 'Deadline date is equal or lower than current date!', 'wpjobster' ),
			'lbl_request_description_empty' => __( 'You cannot leave the description request empty!', 'wpjobster' ),
			'lbl_request_title_empty'       => __( 'You cannot leave the title request empty!', 'wpjobster' ),
			'lvl_saved_lbl'                 => __( 'Saved', 'wpjobster' ),
			'lbl_elementary'                => __( 'Elementary', 'wpjobster' ),
			'lbl_limited'                   => __( 'Limited', 'wpjobster' ),
			'lbl_professional'              => __( 'Professional', 'wpjobster' ),
			'lbl_native'                    => __( 'Native / Bilingual', 'wpjobster' ),
			'looking_recent_conversations'  => __( 'We were just looking for recent conversations.', 'wpjobster' ),
			'media_blank'                   => __( 'You need to upload at least one media for your verification.', 'wpjobster' ),
			'msg_err'                       => __( 'Please write something in the text field.', 'wpjobster' ),
			'no_certifications'             => __( 'Click on "Add New" to add a new Certification!', 'wpjobster' ),
			'no_credits'                    => __( 'The selected job can\'t be activated until you add credits to your account.', 'wpjobster' ),
			'no_description'                => __( 'Click on "Edit Description" to add a Description!', 'wpjobster' ),
			'no_educations'                 => __( 'Click on "Add New" to add a new Education!', 'wpjobster' ),
			'no_languages'                  => __( 'Click on "Add New" to add a new Language!', 'wpjobster' ),
			'no_quick_responses'            => __( 'No quick responses', 'wpjobster' ),
			'no_skills'                     => __( 'Click on "Add New" to add a new Skill!', 'wpjobster' ),
			'no_tagline'                    => __( 'Click here to add a tagline!', 'wpjobster' ),
			'no_user_current_screen'        => __( 'No users were found on the current screen.', 'wpjobster' ),
			'no_user_found'                 => __( 'No user found.', 'wpjobster' ),
			'not_allowed_delete_account'    => __( 'Not allowed. Complete the active orders.', 'wpjobster' ),
			'not_enough_credits'            => __( 'You don\'t have enough money in your balance!', 'wpjobster' ),
			'not_your_post'                 => __( 'This is not your post.', 'wpjobster' ),
			'not_logged_in'                 => __( 'You need to login.', 'wpjobster' ),
			'nothing_found'                 => __( 'No results found.', 'wpjobster' ),
			'now'                           => __( 'Now', 'wpjobster' ),
			'please_wait'                   => __( 'Please wait...', 'wpjobster' ),
			'pm'                            => __( 'PM', 'wpjobster' ),
			'read_less'                     => __( 'Read Less', 'wpjobster' ),
			'read_more'                     => __( 'Read More', 'wpjobster' ),
			'requests_label'                => __( 'Requests', 'wpjobster' ),
			'save_lbl'                      => __( 'Save', 'wpjobster' ),
			'search_older_conversations'    => __( 'Do you want to search for older conversations?', 'wpjobster' ),
			'search_users_label'            => __( 'Search users containing', 'wpjobster' ),
			'select_subcategory'            => __( 'Select Subcategory', 'wpjobster' ),
			'subscription_empty'            => __( 'Please select a plan.', 'wpjobster' ),
			'success'                       => __( 'Success', 'wpjobster' ),
			'success_saved'                 => __( 'Your settings have been saved.', 'wpjobster' ),
			'topup_package_empty'           => __( 'Please select the package first', 'wpjobster' ),
			'uncheck_all_email'             => __( 'Uncheck all', 'wpjobster' ),
			'uncheck_all_sms'               => __( 'Uncheck all', 'wpjobster' ),
			'users_label'                   => __( 'Users', 'wpjobster' ),
			'withdrawn'                     => __( 'Withdrawn', 'wpjobster' ),
			'write_message'                 => __( 'Write a message...', 'wpjobster' ),
			'withdrawal_request'            => __( 'The withdrawal request was sent successfully.', 'wpjobster' )
		];

// ADMIN
		$admin_strings = [];

		if ( is_admin() ) {
			$admin_strings += [
				'admin_url'           => get_admin_url(),
				'position'            => $jobster_settings['wpjobster_currency_position'],
				'space'               => $jobster_settings['wpjobster_currency_symbol_space'],
				'symbol'              => wpj_get_currency_symbol_by_name( wpj_get_site_currency() ),
				'allow_html_emails'   => $jobster_settings['wpjobster_allow_html_emails'],
				'arbitration_number'  => is_admin() ? wpj_get_arbitrations_in_review_count() : 0,
				'semantic_file_url'   => get_template_directory_uri() . '/vendor/semantic-ui/src/app.php',
				'tomtom_api_key'      => $jobster_settings['wpjobster_tomtom_search_api_key'] ?? '',
				'locations_api_key'   => $jobster_settings['wpjobster_google_maps_api_key'] ?? '',
				'locations_api'       => $jobster_settings['wpjobster_location_api_provider'],
				'locations_country'   => ! empty( $jobster_settings['wpjobster_location_restrict_country'] ) ? array_map( 'trim', explode( ',', $jobster_settings['wpjobster_location_restrict_country'] ) ) : [],
				'new_request_page_id' => $jobster_settings['wpjobster_new_request_page_id'],
				'new_job_page_id'     => $jobster_settings['wpjobster_post_new_page_id'],
			];

			$admin_strings += [
				'amount'              => __( 'Amount', 'wpjobster' ),
				'date'                => __( 'Date', 'wpjobster' ),
				'clear'               => __( 'Clear', 'wpjobster' ),
				'custom'              => __( 'Custom', 'wpjobster' ),
				'from'                => __( 'From', 'wpjobster' ),
				'last_7_days'         => __( 'Last 7 Days', 'wpjobster' ),
				'last_30_days'        => __( 'Last 30 Days', 'wpjobster' ),
				'last_month'          => __( 'Last Month', 'wpjobster' ),
				'lbl_loading'         => __( 'Loading...', 'wpjobster' ),
				'payment_type'        => __( 'Payment type', 'wpjobster' ),
				'please_wait_seconds' => __( 'Please wait a few seconds...', 'wpjobster' ),
				'this_month'          => __( 'This Month', 'wpjobster' ),
				'to'                  => __( 'To', 'wpjobster' ),
				'today'               => __( 'Today', 'wpjobster' ),
				'submit'              => __( 'Submit', 'wpjobster' ),
				'yesterday'           => __( 'Yesterday', 'wpjobster' )
			];

			$admin_strings += [
				'days' => [
					'su' => _x( 'Su', 'Abbreviation of: Sunday', 'wpjobster' ),
					'mo' => _x( 'Mo', 'Abbreviation of: Monday', 'wpjobster' ),
					'tu' => _x( 'Tu', 'Abbreviation of: Tuesday', 'wpjobster' ),
					'we' => _x( 'We', 'Abbreviation of: Wednesday', 'wpjobster' ),
					'th' => _x( 'Th', 'Abbreviation of: Thursday', 'wpjobster' ),
					'fr' => _x( 'Fr', 'Abbreviation of: Friday', 'wpjobster' ),
					'sa' => _x( 'Sa', 'Abbreviation of: Saturday', 'wpjobster' ),
				],
				'months' => [
					'jan' => _x( 'January', 'Full name of: January', 'wpjobster' ),
					'feb' => _x( 'February', 'Full name of: February', 'wpjobster' ),
					'mar' => _x( 'March', 'Full name of: March', 'wpjobster' ),
					'apr' => _x( 'April', 'Full name of: April', 'wpjobster' ),
					'may' => _x( 'May', 'Full name of: May', 'wpjobster' ),
					'jun' => _x( 'June', 'Full name of: June', 'wpjobster' ),
					'jul' => _x( 'July', 'Full name of: July', 'wpjobster' ),
					'aug' => _x( 'August', 'Full name of: August', 'wpjobster' ),
					'sep' => _x( 'September', 'Full name of: September', 'wpjobster' ),
					'oct' => _x( 'October', 'Full name of: October', 'wpjobster' ),
					'nov' => _x( 'November', 'Full name of: November', 'wpjobster' ),
					'dec' => _x( 'December', 'Full name of: December', 'wpjobster' ),
				]
			];
		}

// COMMON
		$common_strings = [];

		/* VARS */
		$allowed_mime_types = $jobster_settings['wpjobster_allowed_mime_types'];

		if ( is_string( $allowed_mime_types ) ) $allowed_mime_types = explode( ',', $allowed_mime_types );

		$common_strings += [
			'ajaxurl'                 => admin_url( 'admin-ajax.php' ),
			'allowed_mime_types'      => json_encode( $allowed_mime_types ),
			'attachment_filesize_max' => wpj_get_media_max_upload_size( 'attachment' ),
			'is_rtl'                  => is_rtl(),
			'is_user_logged_in'       => is_user_logged_in(),
			'live_notify'             => $jobster_settings['wpjobster_enable_live_notifications'],
			'site_URL'                => get_site_URL(),
			'theme_path'              => get_template_directory_uri(),
			'uid'                     => get_current_user_id(),
			'is_user_admin'           => current_user_can( 'manage_options' )
		];

		/* STRINGS */
		$common_strings += [
			'cancelled'                        => __( 'Cancelled', 'wpjobster' ),
			'err'                              => __( 'Error', 'wpjobster' ),
			'error_403'                        => __( '403 Forbidden', 'wpjobster' ),
			'error_404'                        => __( '404 Error', 'wpjobster' ),
			'finished'                         => __( 'Finished', 'wpjobster' ),
			'forbidden_file_type'              => __( 'Forbidden file type', 'wpjobster' ),
			'invalid_file_type'                => __( 'Invalid file type.', 'wpjobster' ),
			'lbl_request_cf_empty'             => __( 'You cannot leave empty the following field:', 'wpjobster' ),
			'maximum_file_size_exceeded'       => __( 'Maximum file size exceeded', 'wpjobster' ),
			'maximum_number_of_files_exceeded' => __( 'Maximum number of files exceeded.', 'wpjobster' ),
			'select_file'                      => __( 'Select file', 'wpjobster' ),
			'unknown_error'                    => __( 'Unknown Error', 'wpjobster' ),
			'user_filesize_min_msg'            => __( 'Minimum file size: 250px x 250px', 'wpjobster' ),
			'user_filetype_msg'                => __( 'Allowed file types: .jpg, .jpeg, .png, .gif', 'wpjobster' )
		];

		/* STRING WIHT VARS */
		$common_strings += [
			'attachments_max_size_err' => sprintf( __( 'Maximum file size is %s MB!', 'wpjobster' ), wpj_get_media_max_upload_size( 'attachment', 'original' ) ),
			'avatar_filesize_max'      => wpj_get_media_max_upload_size( 'avatar' ),
			'avatar_filesize_msg'      => sprintf( __( 'Maximum file size is %s MB!', 'wpjobster' ), wpj_get_media_max_upload_size( 'avatar', 'original' ) ),
			'banner_filesize_max'      => wpj_get_media_max_upload_size( 'banner' ),
			'banner_filesize_msg'      => sprintf( __( 'Maximum file size is %s MB!', 'wpjobster' ), wpj_get_media_max_upload_size( 'banner', 'original' ) ),
			'skill_filesize_max'       => wpj_get_media_max_upload_size( 'skill' ),
			'skill_filesize_msg'       => sprintf( __( 'Maximum file size is %s MB!', 'wpjobster' ), wpj_get_media_max_upload_size( 'skill', 'original' ) ),
			'audio_filesize_max'       => wpj_get_media_max_upload_size( 'audio' ),
			'audio_filesize_msg'       => sprintf( __( 'Maximum file size is %s MB!', 'wpjobster' ), wpj_get_media_max_upload_size( 'audio', 'original' ) )
		];

		/* DROPZONE */
		$common_strings += [
			'dictFallbackMessage'          => addslashes( __( 'Your browser does not support drag\'n\'drop file uploads.', 'wpjobster' ) ),
			'dictFallbackText'             => addslashes( __( 'Please use the fallback form below to upload your files like in the olden days.', 'wpjobster' ) ),
			'dictFileTooBig'               => addslashes( __( 'File is too big ({{filesize}}MiB). Max filesize: {{maxFilesize}}MiB.', 'wpjobster' ) ),
			'dictInvalidFileType'          => addslashes( __( 'You can\'t upload files of this type.', 'wpjobster' ) ),
			'dictResponseError'            => addslashes( __( 'Server responded with {{statusCode}} code.', 'wpjobster' ) ),
			'dictCancelUpload'             => addslashes( __( 'Cancel upload', 'wpjobster' ) ),
			'dictCancelUploadConfirmation' => addslashes( __( 'Are you sure you want to cancel this upload?', 'wpjobster' ) ),
			'dictRemoveFile'               => addslashes( __( 'Remove file', 'wpjobster' ) ),
			'dictMaxFilesExceeded'         => addslashes( __( 'You cannot upload any more files.', 'wpjobster' ) ),
			'dictdragDropBrowse'           => addslashes( __( 'Drag & Drop a Photo or <span>Browse</span>', 'wpjobster' ) )
		];

// LOCALIZE

		$admin_strings = apply_filters( 'wpj_localize_strings_filter', $admin_strings + $common_strings );
		$front_strings = apply_filters( 'wpj_localize_strings_filter', $front_strings + $common_strings );

		wp_localize_script( 'wpj-admin-scripts', 'wpj_vars', $admin_strings );
		wp_localize_script( 'wpj-front-scripts', 'wpj_vars', $front_strings );
	}
}
