<?php
add_action( 'after_setup_theme', 'wpj_setup_thumbnails' );
if ( ! function_exists( 'wpj_setup_thumbnails' ) ) {
	function wpj_setup_thumbnails() {
		add_theme_support( 'post-thumbnails' );

		// job images
		$tps = wpj_get_image_size_vals( 'thumb_picture', [ 'w' => 300, 'h' => 207 ] );

		add_image_size( 'thumb_picture_size', $tps['w'], $tps['h'], $tps['c'] );

		$jci = wpj_get_image_size_vals( 'job_cover_image', [ 'w' => 1170, 'h' => 215 ] );

		add_image_size( 'job_cover_image', $jci['w'], $jci['h'], $jci['c'] );

		$jsi = wpj_get_image_size_vals( 'job_slider_image', [ 'w' => 720, 'h' => 405 ] );

		add_image_size( 'job_slider_image', $jsi['w'], $jsi['h'], $jsi['c'] );

		// news & blog images
		$btb = wpj_get_image_size_vals( 'blog_thumbnail_big', [ 'w' => 980, 'h' => 405 ] );

		add_image_size( 'blog_thumbnail_big', $btb['w'], $btb['h'], $btb['c'] );

		$ns = wpj_get_image_size_vals( 'news_slider', [ 'w' => 486, 'h' => 220 ] );

		add_image_size( 'news_slider', $ns['w'], $ns['h'], $ns['c'] );

		// square for general use
		$s150 = wpj_get_image_size_vals( 'square_150', [ 'w' => 150, 'h' => 150 ] );

		add_image_size( 'square_150', $s150['w'], $s150['h'], $s150['c'] );

		$s180 = wpj_get_image_size_vals( 'square_180', [ 'w' => 180, 'h' => 180 ] );

		add_image_size( 'square_180', $s180['w'], $s180['h'], $s180['c'] );
	}
}

add_filter( 'admin_init', 'wpj_add_custom_sizes_to_media_settings' );
if ( ! function_exists( 'wpj_add_custom_sizes_to_media_settings' ) ) {
	function wpj_add_custom_sizes_to_media_settings() {
		/*** JOB ***/

		// thumb_picture_size
		add_settings_field( 'thumb_picture_size', __( 'Job thumbnail size' , 'wpjobster' ), 'wpj_thumb_picture_size_fnc', 'media' );
		wpj_register_image_size_value( 'thumb_picture' );

		// job_cover_image
		add_settings_field( 'job_cover_image', __( 'Job cover image' , 'wpjobster' ), 'wpj_job_cover_image_fnc', 'media' );
		wpj_register_image_size_value( 'job_cover_image' );

		// job_slider_image
		add_settings_field( 'job_slider_image', __( 'Job slider image' , 'wpjobster' ), 'wpj_job_slider_image_fnc', 'media' );
		wpj_register_image_size_value( 'job_slider_image' );

		/*** NEWS ***/

		// blog_thumbnail_big
		add_settings_field( 'blog_thumbnail_big', __( 'Blog big thumbnail' , 'wpjobster' ), 'wpj_blog_thumbnail_big_fnc', 'media' );
		wpj_register_image_size_value( 'blog_thumbnail_big' );

		// news_slider
		add_settings_field( 'news_slider', __( 'News slider image' , 'wpjobster' ), 'wpj_news_slider_fnc', 'media' );
		wpj_register_image_size_value( 'news_slider' );

		/*** SQUARE ***/

		// square_150
		add_settings_field( 'square_150', __( 'Square 150' , 'wpjobster' ), 'wpj_square_150_fnc', 'media' );
		wpj_register_image_size_value( 'square_150' );

		// square_180
		add_settings_field( 'square_180', __( 'Square 180' , 'wpjobster' ), 'wpj_square_180_fnc', 'media' );
		wpj_register_image_size_value( 'square_180' );
	}
}

// Thumbnail picture size function
if ( ! function_exists( 'wpj_thumb_picture_size_fnc' ) ) {
	function wpj_thumb_picture_size_fnc() {
		wpj_display_image_size_html( 'thumb_picture', __( 'Thumbnail picture size', 'wpjobster' ), $default = [ 'w' => 300, 'h' => 207 ] );
	}
}

// Job cover image function
if ( ! function_exists( 'wpj_job_cover_image_fnc' ) ) {
	function wpj_job_cover_image_fnc() {
		wpj_display_image_size_html( 'job_cover_image', __( 'Job cover image', 'wpjobster' ), $default = [ 'w' => 1170, 'h' => 215 ] );
	}
}

// Job slider image function
if ( ! function_exists( 'wpj_job_slider_image_fnc' ) ) {
	function wpj_job_slider_image_fnc() {
		wpj_display_image_size_html( 'job_slider_image', __( 'Job slider image', 'wpjobster' ), $default = [ 'w' => 720, 'h' => 405 ] );
	}
}

// News slider image function
if ( ! function_exists( 'wpj_blog_thumbnail_big_fnc' ) ) {
	function wpj_blog_thumbnail_big_fnc() {
		wpj_display_image_size_html( 'blog_thumbnail_big', __( 'Blog big thumbnail', 'wpjobster' ), $default = [ 'w' => 980, 'h' => 405 ] );
	}
}

// Blog big thumbnail function
if ( ! function_exists( 'wpj_news_slider_fnc' ) ) {
	function wpj_news_slider_fnc() {
		wpj_display_image_size_html( 'news_slider', __( 'News slider image', 'wpjobster' ), $default = [ 'w' => 486, 'h' => 220 ] );
	}
}

// Square 150
if ( ! function_exists( 'wpj_square_150_fnc' ) ) {
	function wpj_square_150_fnc() {
		wpj_display_image_size_html( 'square_150', __( 'Square 150', 'wpjobster' ), $default = [ 'w' => 150, 'h' => 150 ] );
	}
}

// Square 180
if ( ! function_exists( 'wpj_square_180_fnc' ) ) {
	function wpj_square_180_fnc() {
		wpj_display_image_size_html( 'square_180', __( 'Square 180', 'wpjobster' ), $default = [ 'w' => 180, 'h' => 180 ] );
	}
}

/*** HELPERS ***/
if ( ! function_exists( 'wpj_get_image_size_vals' ) ) {
	function wpj_get_image_size_vals( $image_size = '', $default = [ 'w' => 150, 'h' => 150 ] ) {
		$w_option = wpj_get_option( $image_size . '_size_w' );
		$h_option = wpj_get_option( $image_size . '_size_h' );
		$c_option = wpj_get_option( $image_size . '_crop' );

		$width  = $w_option && is_numeric( $w_option ) ? $w_option : $default['w'];
		$height = $h_option && is_numeric( $h_option ) ? $h_option : $default['h'];
		$crop   = $c_option ? true : false;

		return ['w' => $width, 'h' => $height, 'c' => $crop];
	}
}

if ( ! function_exists( 'wpj_register_image_size_value' ) ) {
	function wpj_register_image_size_value ( $image_size = '' ) {
		register_setting( 'media', $image_size . '_size_w', 'esc_attr' );
		register_setting( 'media', $image_size . '_size_h', 'esc_attr' );
		register_setting( 'media', $image_size . '_crop', 'esc_attr' );
	}
}

if ( ! function_exists( 'wpj_display_image_size_html' ) ) {
	function wpj_display_image_size_html( $image_size = '', $label = '', $default = [ 'w' => 150, 'h' => 150 ] ) { ?>
		<fieldset>

			<legend class="screen-reader-text">
				<span><?php echo $label; ?></span>
			</legend>

			<label for="<?php echo $image_size . '_size_w'; ?>"><?php _e( 'Max Width' , 'wpjobster' ); ?></label>
			<input name="<?php echo $image_size . '_size_w'; ?>" type="number" step="1" min="0" id="<?php echo $image_size . '_size_w'; ?>" value="<?php echo wpj_get_option( $image_size . '_size_w' ) ? wpj_get_option( $image_size . '_size_w' ) : $default['w']; ?>" class="small-text">

			<br>

			<label for="<?php echo $image_size . '_size_h'; ?>"><?php _e( 'Max Height' , 'wpjobster' ); ?></label>
			<input name="<?php echo $image_size . '_size_h'; ?>" type="number" step="1" min="0" id="<?php echo $image_size . '_size_h'; ?>" value="<?php echo wpj_get_option( $image_size . '_size_h' ) ? wpj_get_option( $image_size . '_size_h' ) : $default['h']; ?>" class="small-text">

		</fieldset>

		<input name="<?php echo $image_size . '_crop'; ?>" type="checkbox" id="<?php echo $image_size . '_crop'; ?>" <?php echo wpj_get_option( $image_size . '_crop' ) ? 'checked="checked"' : ''; ?>>

		<label for="<?php echo $image_size . '_crop'; ?>"><?php _e( 'Crop thumbnail to exact dimensions (normally thumbnails are proportional)' , 'wpjobster' ); ?></label>
	<?php }
}

add_filter( 'upload_mimes', 'wpj_set_allowed_upload_mimes' );
if ( ! function_exists( 'wpj_set_allowed_upload_mimes' ) ) {
	function wpj_set_allowed_upload_mimes( $existing_mimes = [] ) {
		if ( is_string( wpj_get_option( 'wpjobster_allowed_mime_types' ) ) ) {
			$allowed    = explode( ',', wpj_get_option( 'wpjobster_allowed_mime_types' ) );
			$mime_types = wpj_get_mimes_types_list();

			if ( ! empty( $allowed ) ) {
				foreach ( $allowed as $val ) {
					if ( isset( $mime_types[$val] ) ) {
						$existing_mimes[$val] = $mime_types[$val];
					} else {
						$existing_mimes[$val] = 'application/' . $val;
					}
				}

			} else {
				$existing_mimes[] = '';

			}
		}

		return $existing_mimes;
	}
}

// Hide private files from media library
add_filter( 'ajax_query_attachments_args', function( $args ) {
	$args['meta_query'] = [
		'relation' => 'AND',
		['key' => 'pm_id',      'compare' => 'NOT EXISTS'],
		['key' => 'message_id', 'compare' => 'NOT EXISTS'],
		['key' => 'job_id',     'compare' => 'NOT EXISTS']
	];

	return $args;
} );