<?php
add_action( 'after_setup_theme', 'wpj_register_menus' );
if ( ! function_exists( 'wpj_register_menus' ) ) {
	function wpj_register_menus() {
		register_nav_menu( 'wpjobster_header_main_menu'              , 'Header Main Menu' );

		register_nav_menu( 'wpjobster_header_secondary_menu'         , 'Header Secondary Menu' );
		register_nav_menu( 'wpjobster_header_secondary_loggedin_menu', 'Header Secondary Logged In Menu' );

		register_nav_menu( 'wpjobster_responsive_left_menu'          , 'Responsive Left Menu' );
		register_nav_menu( 'wpjobster_responsive_right_menu'         , 'Responsive Right Menu' );

		register_nav_menu( 'wpjobster_responsive_left_loggedin_menu' , 'Responsive Left Menu - Logged In' );
		register_nav_menu( 'wpjobster_responsive_right_loggedin_menu', 'Responsive Right Menu - Logged In' );

		register_nav_menu( 'wpjobster_header_user_account_menu'      , 'Header User Account Menu' );
		register_nav_menu( 'wpjobster_header_user_dropdown_menu'     , 'Header User Dropdown Menu' );

		register_nav_menu( 'wpjobster_user_account_sidebar_menu'     , 'User Account Sidebar Menu' );
	}
}

add_action( 'init', 'wpj_show_hide_menu_bar' );
function wpj_show_hide_menu_bar() {
	$user = wp_get_current_user();

	if (
		array_intersect( ['editor', 'administrator', 'author'], $user->roles )
		&& wpj_is_iframe_previous_pageload() === false
		&& ! wp_is_mobile()
	) {
		// let him choose

	} else {
		show_admin_bar( false );

	}
}
