<?php
add_action( 'template_redirect', 'wpj_add_page_content', 2 );
if ( ! function_exists( 'wpj_add_page_content' ) ) {
	function wpj_add_page_content() {
		$wpj_get_page_ids = wpj_get_page_ids();

		// if current page is one of the jobster pages
		if ( is_page( array_values( $wpj_get_page_ids ) ) ) {
			$page_id = get_queried_object_id();

			// get option name
			$op_name = array_search( $page_id, $wpj_get_page_ids );

			// get function name
			$wpj_get_page_functions = wpj_get_page_functions();
			$fnc_name = $wpj_get_page_functions[$op_name];

			// check access conditions
			do_action( 'wpj_before_load_page', $op_name, $fnc_name );

			// if is code, call function
			if ( wpj_page_content_type( $page_id ) == 'code' ) {
				get_header();

				call_user_func( $fnc_name );

				get_footer();

				die();
			}
		}
	}
}

add_action( 'wpj_before_load_page', 'wpj_add_page_access_conditions', 10, 2 );
if ( ! function_exists( 'wpj_add_page_access_conditions' ) ) {
	function wpj_add_page_access_conditions( $op_name, $fnc_name ) {
		global $wp_query;

		// Logged in
		if (
			( wpj_is_page( 'wpjobster_login_page_id' )
				|| wpj_is_page( 'wpjobster_register_page_id' )
				|| wpj_is_page( 'wpjobster_forgot_password_page_id' )
			) && is_user_logged_in()
		) {
			$redirect_url = get_permalink( apply_filters( 'wpj_redirect_logged_in_user_page_id_filter', wpj_get_option( 'main_page_url_user' ) ) );
		}

		// Not Logged in
		if ( is_page( wpj_get_user_logged_in_pages() ) && ! is_user_logged_in() ) {
			$redirect_url = apply_filters( 'wpj_redirect_not_logged_in_user_page_id_filter', wpj_get_login_link() );
		}

		// Job checkout
		if ( wpj_is_page( 'wpjobster_checkout_page_id' ) ) {
			if ( ! isset( $_POST['jobid'] ) && ! isset( $_POST['oid'] ) ) {
				$redirect_url = wpj_get_payment_info_by_url( 'redirect_link' );
			}

			if ( ! isset( $_POST['purchaseformvalidation'] ) ) {
				$redirect_url = wpj_get_payment_info_by_url( 'redirect_link' );
			}

			$pid = wpj_get_payment_info_by_url( 'pid' );

			if ( wpj_get_payment_info_by_url( 'pid' ) && get_post_field( 'post_author', $pid ) == get_current_user_id() ) {
				$redirect_url = get_bloginfo( 'url' );
			}

			if ( wpj_get_payment_info_by_url( 'payment_type' ) == 'job_purchase' && wpj_is_custom_offer( $pid ) ) {
				$offer_veracity = wpj_check_offer_veracity( $pid, get_post_field( 'post_author', $pid ) );

				if ( $offer_veracity ) {
					$redirect_url = $offer_veracity;
				}
			}

			if ( wpj_get_payment_info_by_url( 'payment_type' ) == 'custom_extra' ) {
				$order = wpj_get_payment_info_by_url( 'order' );

				if ( $order->uid != get_current_user_id() ) {
					$redirect_url = get_bloginfo( 'url' );
				}

				$custom_extra = wpj_get_payment_info_by_url( 'custom_extra' );

				if ( ! $custom_extra || $custom_extra->paid == true || $custom_extra->declined == true || $custom_extra->cancelled == true ) {
					$redirect_url = wpj_get_order_link( wpj_get_payment_info_by_url( 'oid' ) );
				}
			}

			if ( wpj_get_payment_info_by_url( 'payment_type' ) == 'tips' ) {
				$order = wpj_get_payment_info_by_url( 'order' );

				if ( $order->uid != get_current_user_id() ) {
					$redirect_url = get_bloginfo( 'url' );
				}

				$tip = wpj_get_payment_info_by_url( 'tip' );

				if ( ! $tip || $tip->paid == true ) {
					$redirect_url = wpj_get_order_link( wpj_get_payment_info_by_url( 'oid' ) );
				}
			}
		}

		// Order
		if ( wpj_is_page( 'wpjobster_order_page_id' ) ) {
			if ( ! isset( $wp_query->query_vars['oid'] ) && ! isset( $_POST['custom_extra'] ) && ! isset( $_POST['tips'] ) ) {
				$redirect_url = get_bloginfo( 'url' );

			} elseif ( isset( $wp_query->query_vars['oid'] ) && ! wpj_get_job_order_by_id( $wp_query->query_vars['oid'] ) ) {
				$redirect_url = get_bloginfo( 'url' );

			} elseif (
				isset( $wp_query->query_vars['oid'] )
				&& ! current_user_can( 'manage_options' )
				&& wpj_get_seller_id( $wp_query->query_vars['oid'] ) != get_current_user_id()
				&& wpj_get_buyer_id( $wp_query->query_vars['oid'] ) != get_current_user_id()
			) {
				$redirect_url = get_bloginfo( 'url' );

			}
		}

		// Topup
		if ( wpj_is_page( 'wpjobster_topup_order_page_id' ) ) {
			if ( ! isset( $wp_query->query_vars['oid'] ) ) {
				$redirect_url = get_bloginfo( 'url' );
			}
		}

		// Featured
		if ( wpj_is_page( 'wpjobster_feature_page_id' ) ) {
			$pid = wpj_get_post_id();

			if ( get_post_field( 'post_author', $pid ) != get_current_user_id() ) {
				$redirect_url = get_permalink( wpj_get_option( 'wpjobster_my_account_page_id' ) );

			} elseif ( $pid == wpj_get_option( 'wpjobster_feature_page_id' ) ) {
				$redirect_url = get_bloginfo( 'url' );

			}

		}

		// User profile
		if ( wpj_is_page( 'wpjobster_user_profile_page_id' ) ) {
			// Redirect to homepage if username not exist
			if ( ! username_exists( wpj_get_URL_user( 'username' ) ) ) {
				$redirect_url = get_permalink( apply_filters( 'wpj_redirect_not_logged_in_user_page_id_filter', wpj_get_option( 'main_page_url' ) ) );
			}

			// Redirect to own user profile page if accessed directly
			elseif ( ! wpj_get_URL_user( 'username' ) && wpj_get_user_id() == get_current_user_id() ) {
				$redirect_url = wpj_get_user_profile_link( get_current_user_id() );
			}
		}

		// PM
		if ( wpj_is_page( 'wpjobster_my_account_priv_mess_page_id' ) && wpj_get_pm_interlocutor_from_url( 'id' ) == get_current_user_id() ) {
			$redirect_url = get_permalink();
		}

		// Single job
		if ( wpj_is_page( 'wpjobster_single_job_page_id' ) ) {
			$redirect_url = get_permalink( wpj_get_option( 'wpjobster_advanced_search_id' ) );
		}

		// Single request
		if ( wpj_is_page( 'wpjobster_single_request_page_id' ) ) {
			$redirect_url = get_permalink( wpj_get_option( 'wpjobster_advanced_search_request_page_id' ) );
		}

		// Single blog
		if ( wpj_is_page( 'wpjobster_single_blog_page_id' ) ) {
			$redirect_url = get_permalink( wpj_get_option( 'wpjobster_all_blog_posts_page_id' ) );
		}

		// Single news
		if ( wpj_is_page( 'wpjobster_single_news_page_id' ) ) {
			$redirect_url = get_permalink( wpj_get_option( 'wpjobster_all_news_page_id' ) );
		}

		if ( ! empty ( $redirect_url ) ) {
			wp_redirect( $redirect_url );

			die();
		}

		// Post new request
		if ( wpj_is_page( 'wpjobster_new_request_page_id' ) ) {
			wpj_create_request_post_id();
		}

		// Post new job
		if ( wpj_is_page( 'wpjobster_post_new_page_id' ) ) {
			wpj_create_job_post_id();
		}

		do_action( 'wpj_after_page_access_conditions' );

	}
}

add_action( 'query_vars', 'wpj_add_query_vars' );
if ( ! function_exists( 'wpj_add_query_vars' ) ) {
	function wpj_add_query_vars( $public_query_vars ) {
		$public_query_vars[] = 'oid';
		$public_query_vars[] = 'orderid';
		$public_query_vars[] = 'step';
		$public_query_vars[] = 'username';
		$public_query_vars[] = 'pid';
		$public_query_vars[] = 'term_search';
		$public_query_vars[] = 'method';
		$public_query_vars[] = 'jobid';
		$public_query_vars[] = 'page';
		$public_query_vars[] = 'job_category';
		$public_query_vars[] = 'job_sort';
		$public_query_vars[] = 'job_tax';
		$public_query_vars[] = 'pg';
		$public_query_vars[] = 'message_id';

		return $public_query_vars;
	}
}

add_action( 'redux/options/jobster_settings/saved', 'wpj_set_homepage_and_blog_id_for_wp_settings' );
if ( ! function_exists( 'wpj_set_homepage_and_blog_id_for_wp_settings' ) ) {
	function wpj_set_homepage_and_blog_id_for_wp_settings( $options ) {
		update_option( 'page_on_front', $options['main_page_url'] );
		update_option( 'page_for_posts', $options['wpjobster_all_blog_posts_page_id'] );
	}
}

add_action( 'update_option_page_on_front', 'wpj_set_homepage_id_for_redux', 10, 3 );
if ( ! function_exists( 'wpj_set_homepage_id_for_redux' ) ) {
	function wpj_set_homepage_id_for_redux( $old_value, $value, $option ) {
		if ( class_exists( 'Redux' ) ) {
			Redux::set_option( 'jobster_settings', 'main_page_url', $value );
		}
	}
}

add_action( 'update_option_page_for_posts', 'wpj_set_blog_id_for_redux', 10, 3 );
if ( ! function_exists( 'wpj_set_blog_id_for_redux' ) ) {
	function wpj_set_blog_id_for_redux( $old_value, $value, $option ) {
		if ( class_exists( 'Redux' ) ) {
			Redux::set_option( 'jobster_settings', 'wpjobster_all_blog_posts_page_id', $value );
		}
	}
}
