<?php // Jobs

if ( ! function_exists( 'wpj_get_job_single_permalink' ) ) {
	function wpj_get_job_single_permalink() {
		$page_id = wpj_get_option( 'wpjobster_single_job_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'job';

		} else {
			$slug = 'job';

		}

		return $slug;
	}
}

add_filter( 'post_type_link', 'wpj_change_single_job_link', 1, 3 ); // single link
if ( ! function_exists( 'wpj_change_single_job_link' ) ) {
	function wpj_change_single_job_link( $post_link, $id = 0, $leavename = FALSE ) {
		$category_url_link = wpj_get_job_category_permalink();

		if ( strpos( '%job_cat%', $post_link ) === 'FALSE' ) { return $post_link; }

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'job' ) {
			return str_replace( "job_cat", $category_url_link, $post_link );
		}

		$terms = wp_get_object_terms( $post->ID, 'job_cat' );

		if ( ! $terms ) {
			return str_replace( '%job_cat%', 'uncategorized', $post_link );
		}

		return str_replace( '%job_cat%', $terms[0]->slug, $post_link );
	}
}

if ( ! function_exists( 'wpj_get_job_category_permalink' ) ) {
	function wpj_get_job_category_permalink() {
		return ! empty( wpj_get_option( 'wpjobster_category_permalink' ) ) ? wpj_get_option( 'wpjobster_category_permalink' ) : 'job-categories';
	}
}

add_filter( 'term_link', 'wpj_change_job_category_link', 1, 3 ); // category link
if ( ! function_exists( 'wpj_change_job_category_link' ) ) {
	function wpj_change_job_category_link( $post_link, $id = 0, $leavename = FALSE ) {
		if ( ! wpj_use_permalinks() ) {
			return $post_link;
		}

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'job' ) {
			$category_url_link = wpj_get_job_category_permalink();

			return str_replace( "job_cat", $category_url_link, $post_link );
		}

		return $post_link;
	}
}

// Requests

if ( ! function_exists( 'wpj_get_all_requests_permalink' ) ) {
	function wpj_get_all_requests_permalink() {
		$page_id = wpj_get_option( 'wpjobster_all_requests_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'requests';

		} else {
			$slug = 'requests';

		}

		return $slug;
	}
}

if ( ! function_exists( 'wpj_get_request_single_permalink' ) ) {
	function wpj_get_request_single_permalink() {
		$page_id = wpj_get_option( 'wpjobster_single_request_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'request';

		} else {
			$slug = 'request';

		}

		return $slug;
	}
}

add_filter( 'post_type_link', 'wpj_change_single_request_link', 1, 3 ); // single link
if ( ! function_exists( 'wpj_change_single_request_link' ) ) {
	function wpj_change_single_request_link( $post_link, $id = 0, $leavename = FALSE ) {
		$category_url_link = wpj_get_request_category_permalink();

		if ( strpos( '%request_cat%', $post_link ) === 'FALSE' ) { return $post_link; }

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'request' ) {
			return str_replace( "request_cat", $category_url_link, $post_link );
		}

		$terms = wp_get_object_terms( $post->ID, 'request_cat' );

		if ( ! $terms ) {
			return str_replace( '%request_cat%', 'uncategorized', $post_link );
		}

		return str_replace( '%request_cat%', $terms[0]->slug, $post_link );
	}
}

if ( ! function_exists( 'wpj_get_request_category_permalink' ) ) {
	function wpj_get_request_category_permalink() {
		return ! empty( wpj_get_option( 'wpjobster_requests_category_permalink' ) ) ? wpj_get_option( 'wpjobster_requests_category_permalink' ) : 'request-categories';
	}
}

add_filter( 'term_link', 'wpj_change_request_category_link', 1, 3 ); // category link
if ( ! function_exists( 'wpj_change_request_category_link' ) ) {
	function wpj_change_request_category_link( $post_link, $id = 0, $leavename = FALSE ) {
		if ( ! wpj_use_permalinks() ) {
			return $post_link;
		}

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'request' ) {
			$category_url_link = wpj_get_request_category_permalink();

			return str_replace( "request_cat", $category_url_link, $post_link );
		}

		return $post_link;
	}
}

// News

if ( ! function_exists( 'wpj_get_all_news_permalink' ) ) {
	function wpj_get_all_news_permalink() {
		$page_id = wpj_get_option( 'wpjobster_all_news_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'news';

		} else {
			$slug = 'news';

		}

		return $slug;
	}
}

if ( ! function_exists( 'wpj_get_news_single_permalink' ) ) {
	function wpj_get_news_single_permalink() {
		$page_id = wpj_get_option( 'wpjobster_single_news_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'news';

		} else {
			$slug = 'news';

		}

		return $slug;
	}
}

add_filter( 'post_type_link', 'wpj_change_single_news_link', 1, 3 ); // single link
if ( ! function_exists( 'wpj_change_single_news_link' ) ) {
	function wpj_change_single_news_link( $post_link, $id = 0, $leavename = FALSE ) {
		$category_url_link = wpj_get_news_category_permalink();

		if ( strpos( '%news_cat%', $post_link ) === 'FALSE' ) { return $post_link; }

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'news' ) {
			return str_replace( "news_cat", $category_url_link, $post_link );
		}

		$terms = wp_get_object_terms( $post->ID, 'news_cat' );

		if ( ! $terms ) {
			return str_replace( '%news_cat%', 'uncategorized', $post_link );
		}

		return str_replace( '%news_cat%', $terms[0]->slug, $post_link );
	}
}

if ( ! function_exists( 'wpj_get_news_category_permalink' ) ) {
	function wpj_get_news_category_permalink() {
		return ! empty( wpj_get_option( 'wpjobster_news_category_permalink' ) ) ? wpj_get_option( 'wpjobster_news_category_permalink' ) : 'news-categories';
	}
}

add_filter( 'term_link', 'wpj_change_news_category_link', 1, 3 ); // category link
if ( ! function_exists( 'wpj_change_news_category_link' ) ) {
	function wpj_change_news_category_link( $post_link, $id = 0, $leavename = FALSE ) {
		if ( ! wpj_use_permalinks() ) return $post_link;

		$post = get_post( $id );

		if ( ! is_object( $post ) || $post->post_type != 'news' ) {
			$category_url_link = wpj_get_news_category_permalink();

			return str_replace( "news_cat", $category_url_link, $post_link );
		}

		return $post_link;
	}
}

// Offers

if ( ! function_exists( 'wpj_get_all_proposals_permalink' ) ) {
	function wpj_get_all_proposals_permalink() {
		$page_id = wpj_get_option( 'wpjobster_all_proposals_page_id' );

		if ( ! empty( $page_id ) ) {
			$post = get_post( $page_id );
			$slug = ! empty( $post->post_name ) ? $post->post_name : 'all-proposals';

		} else {
			$slug = 'all-proposals';

		}

		return $slug;
	}
}

// Change permalink to author

add_filter( 'post_type_link', 'wpj_change_single_link_to_author', 1, 3 ); // single link
if ( ! function_exists( 'wpj_change_single_link_to_author' ) ) {
	function wpj_change_single_link_to_author( $post_link, $post = '', $leavename = false ) {

		if ( strpos( '%author%', $post_link ) === 'FALSE' ) { return $post_link; }

		if ( ! is_object( $post ) || ( $post->post_type != 'job' && $post->post_type != 'request' && $post->post_type != 'news' ) ) {
			return $post_link;
		}

		$user_data = get_userdata( $post->post_author );

		return isset( $user_data->user_login ) ? str_replace( '%author%', $user_data->user_login, $post_link ) : $post_link;
	}
}

// Flush rewrite rules for existing installations
add_action( 'init', function() {
	if ( ! wpj_get_option( 'theme_permalinks_flushed' ) ) {
		flush_rewrite_rules();

		update_option( 'theme_permalinks_flushed', 1 );
	}
}, 99 );