<?php
add_action( 'wpj_after_gateway_compatibility_errors', 'wpj_add_theme_messages_to_plugins', 10, 4 );
add_action( 'wpj_after_plugin_compatibility_errors', 'wpj_add_theme_messages_to_plugins', 10, 4 );
if ( ! function_exists( 'wpj_add_theme_messages_to_plugins' ) ) {
	function wpj_add_theme_messages_to_plugins ( $plugin_version, $plugin_name, $plugin_path, $theme_required_version ) {
		if ( defined( 'wpjobster_VERSION' ) && wpjobster_VERSION < $theme_required_version )
			$error = sprintf( __( 'Your current version of theme is not compatible with %s plugin. Please update the theme to version %s or higher.', 'wpjobster' ), $plugin_name, $theme_required_version );

		if ( version_compare( $plugin_version, '3.0', '<' ) || version_compare( $plugin_version, '3.0.0', '<' ) )
			$error = sprintf( __( 'The current version of %s plugin is not compatible with your theme version. Please update the %s plugin to version 3.0.0 or higher.', 'wpjobster' ), $plugin_name, $plugin_name );

		$plugins = [
			'Account Segregation' => '3.1.2',
			'Affiliate' => '3.0.6',
			'Discounts' => '3.0.8',
			'Invoices' => '3.1.0',
			'Milestone' => '3.0.6'
		];

		foreach ( $plugins as $name => $version ) {
			if ( $plugin_name == $name && version_compare( $plugin_version, $version, '<' ) ) {
				$error = sprintf( __( 'The current version of %s plugin is not compatible with your theme version. Please update the %s plugin to version %s or higher.', 'wpjobster' ), $plugin_name, $plugin_name, $version );
			}
		}

		if ( ! empty( $error ) ) wpj_deactivate_plugin( $plugin_path, $error );
	}
}

add_action( 'admin_init', 'wpj_deactivate_incompatible_plugins' );
if ( ! function_exists( 'wpj_deactivate_incompatible_plugins' ) ) {
	function wpj_deactivate_incompatible_plugins() {
		$wpj_plugins    = wpj_get_wpjobster_plugins_list();
		$active_plugins = wpj_get_option( 'active_plugins' );
		$common_plugins = array_intersect( $wpj_plugins, $active_plugins );

		if ( $common_plugins ) {
			foreach ( $common_plugins as $common_plugin ) {
				$plugin_data = get_plugin_data( WP_PLUGIN_DIR . '/' . $common_plugin );

				if ( version_compare( $plugin_data['Version'], '3.0', '<' ) || version_compare( $plugin_data['Version'], '3.0.0', '<' ) ) {
					$error = sprintf( __( 'The current version of %s plugin is not compatible with your theme version. Please update the %s plugin to version 3.0.0 or higher.', 'wpjobster' ), $plugin_data['Name'], $plugin_data['Name'] );

					wpj_deactivate_plugin( $common_plugin, $error );
				}
			}
		}
	}
}

add_action( 'activate_plugin', 'wpj_skip_redux_activation', 10, 2 );
function wpj_skip_redux_activation( $plugin, $network_wide ) {
	if ( $plugin == 'redux-framework/redux-framework.php' ) {
		$screen = get_current_screen();

		if ( isset( $screen->base ) ) {
			if (
				'toplevel_page_jobster-settings' !== $screen->base
				&& 'toplevel_page_jobster-design' !== $screen->base
				&& 'options' !== $screen->base
				&& ! isset( $_GET['import-pages'] )
				&& ! isset( $_GET['reset-pages'] )
				&& get_option( 'wpjobster_installed_date' )
			) {
				wp_redirect( self_admin_url( 'plugins.php?skip_redux_activation=1' ) );
				exit;
			}
		}
	}
}

add_filter( 'allowed_options', 'wpj_add_redux_groups_settings', 10, 1 );
function wpj_add_redux_groups_settings( $allowed_options ) {
	if ( ! is_plugin_active( 'redux-framework/redux-framework.php' ) ) {
		$allowed_options['jobster_settings_group'] = ['jobster_settings'];
		$allowed_options['jobster_design_group'] = ['jobster_design'];
	}

	return $allowed_options;
}

add_action( 'current_screen', 'wpj_deactivate_redux_admin' );
function wpj_deactivate_redux_admin() {
	$screen = get_current_screen();

	if ( isset( $screen->base ) ) {
		$path_plugin_url = WP_PLUGIN_DIR . '/redux-framework/redux-framework.php';

		if ( file_exists( $path_plugin_url ) ) {
			if (
				get_option( 'wpjobster_installed_date' )
				&& ! isset( $_GET['import-pages'] )
				&& ! isset( $_GET['reset-pages'] )
				&& $screen->base != 'options'
				&& $screen->base != 'toplevel_page_jobster-settings'
				&& $screen->base != 'toplevel_page_jobster-design'
			) {
				deactivate_plugins( 'redux-framework/redux-framework.php' );

			}
		}
	}
}