<?php
add_action( 'init', 'wpj_create_post_type' );
if ( ! function_exists( 'wpj_create_post_type' ) ) {
	function wpj_create_post_type() {
		/* Post type: job */
		register_post_type( 'job',
			[
				'labels' => [
					'name'          => __( 'Jobs', 'wpjobster' ),
					'singular_name' => __( 'Job', 'wpjobster' ),
					'add_new'       => __( 'Add New Job', 'wpjobster' ),
					'new_item'      => __( 'New Job', 'wpjobster' ),
					'edit_item'     => __( 'Edit Job', 'wpjobster' ),
					'add_new_item'  => __( 'Add New Job', 'wpjobster' ),
					'search_items'  => __( 'Search Jobs', 'wpjobster' )
				],
				'public'               => true,
				'menu_position'        => 30,
				'register_meta_box_cb' => 'wpjobster_set_job_metaboxes',
				'has_archive'          => 'jobs',
				'rewrite' => [
					'slug'       => wpj_get_job_single_permalink() . '/' . ( wpj_get_option( 'wpjobster_jobs_permalink_slug_type' ) == 'author' ? '%author%' : '%job_cat%' ),
					'with_front' => false
				],
				'supports' => [
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments',
					'custom-fields'
				],
				'_builtin'           => false,
				'menu_icon'          => get_template_directory_uri() . '/assets/images/admin/post-type-job-icon.webp',
				'publicly_queryable' => true,
				'hierarchical'       => false,
				'show_in_rest'       => true
			]
		);

		/* Post type: request */
		register_post_type( 'request',
			[
				'labels' => [
					'name'          => __( 'Requests', 'wpjobster' ),
					'singular_name' => __( 'Request', 'wpjobster' ),
					'add_new'       => __( 'Add New Request', 'wpjobster' ),
					'new_item'      => __( 'New Request', 'wpjobster' ),
					'edit_item'     => __( 'Edit Request', 'wpjobster' ),
					'add_new_item'  => __( 'Add New Request', 'wpjobster' ),
					'search_items'  => __( 'Search Requests', 'wpjobster' )
				],
				'public'               => true,
				'menu_position'        => 31,
				'register_meta_box_cb' => 'wpjobster_set_request_metaboxes',
				'has_archive'          => wpj_get_all_requests_permalink(),
				'rewrite' => [
					'slug'       => wpj_get_request_single_permalink() . '/' . ( wpj_get_option( 'wpjobster_requests_permalink_slug_type' ) == 'author' ? '%author%' : '%request_cat%' ),
					'with_front' => false
				],
				'supports' => [
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments',
					'custom-fields'
				],
				'_builtin'           => false,
				'menu_icon'          => get_template_directory_uri() . '/assets/images/admin/post-type-request-icon.webp',
				'publicly_queryable' => true,
				'hierarchical'       => false,
				'show_in_rest'       => true
			]
		);

		/* Post type: offer */
		register_post_type( 'offer',
			[
				'labels' => [
					'name'          => __( 'Custom Offers', 'wpjobster' ),
					'singular_name' => __( 'Custom Offer', 'wpjobster' ),
					'add_new'       => __( 'Add New Offer', 'wpjobster' ),
					'new_item'      => __( 'New Offer', 'wpjobster' ),
					'edit_item'     => __( 'Edit Offer', 'wpjobster' ),
					'add_new_item'  => __( 'Add New Offer', 'wpjobster' ),
					'search_items'  => __( 'Search Offer', 'wpjobster' )
				],
				'public'               => false,
				'show_ui'              => true,
				'show_in_menu'         => true,
				'menu_position'        => 32,
				'register_meta_box_cb' => 'wpjobster_set_offer_metaboxes',
				'has_archive'          => 'offer',
				'rewrite' => [
					'slug'       => 'offers',
					'with_front' => false
				],
				'supports' => [
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments',
					'custom-fields'
				],
				'_builtin'           => false,
				'menu_icon'          => get_template_directory_uri() . '/assets/images/admin/post-type-offer-icon.webp',
				'publicly_queryable' => true,
				'hierarchical'       => false
			]
		);

		/* Post type: news */
		register_post_type( 'news',
			[
				'labels' => [
					'name'               => __( 'News','wpjobster' ),
					'singular_name'      => __( 'News','wpjobster' ),
					'add_new'            => __( 'Add New','wpjobster' ),
					'add_new_item'       => __( 'Add New News','wpjobster' ),
					'edit_item'          => __( 'Edit News','wpjobster' ),
					'new_item'           => __( 'New News','wpjobster' ),
					'view_item'          => __( 'View News','wpjobster' ),
					'search_items'       => __( 'Search News','wpjobster' ),
					'not_found'          => __( 'No News Found','wpjobster' ),
					'not_found_in_trash' => __( 'No News Found In Trash','wpjobster' ),
					'parent_item_colon'  => __( 'Parent News:','wpjobster' ),
					'menu_name'          => __( 'News','wpjobster' ),
					'all_items'          => __( 'All News','wpjobster' ),
				],
				'public'        => true,
				'menu_position' => 33,
				'has_archive'   => wpj_get_all_news_permalink(),
				'rewrite'       => [
					'slug'       => wpj_get_news_single_permalink() . '/' . ( wpj_get_option( 'wpjobster_news_permalink_slug_type' ) == 'author' ? '%author%' : '%news_cat%' ),
					'with_front' => false
				],
				'supports' => [
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments',
					'custom-fields'
				],
				'_builtin'           => false,
				'publicly_queryable' => true,
				'hierarchical'       => false,
				'show_in_rest'       => true
			]
		);

		/* Post type: sellers-messages */
		register_post_type( 'sellers-messages',
			[
				'labels' => [
					'name'          => __( 'Sellers Messages', 'wpjobster' ),
					'singular_name' => __( 'Seller Message', 'wpjobster' ),
					'add_new'       => __( 'Add New Message', 'wpjobster' ),
					'new_item'      => __( 'New Message', 'wpjobster' ),
					'edit_item'     => __( 'Edit Message', 'wpjobster' ),
					'add_new_item'  => __( 'Add New Message', 'wpjobster' ),
					'search_items'  => __( 'Search Message', 'wpjobster' )
				],
				'public'        => false,
				'show_ui'       => true,
				'show_in_menu'  => true,
				'menu_position' => 37,
				'has_archive'   => 'message',
				'rewrite' => [
					'slug'       => 'sellers-messages',
					'with_front' => false
				],
				'supports' => [
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments',
					'custom-fields'
				],
				'_builtin'           => false,
				'menu_icon'          => 'dashicons-admin-comments',
				'publicly_queryable' => true,
				'hierarchical'       => false
			]
		);

		/* Taxonomy for job: job categories */
		register_taxonomy( 'job_cat', 'job', [
			'show_in_rest' => true,
			'hierarchical' => true,
			'label'        => __( 'Categories', 'wpjobster' )
		]);

		/* Taxonomy for job: tags */
		register_taxonomy_for_object_type( 'post_tag', 'job' );

		/* Taxonomy for request: request categories */
		register_taxonomy( 'request_cat', 'request', [
			'show_in_rest' => true,
			'hierarchical' => true,
			'label'        => __( 'Categories', 'wpjobster' )
		]);

		/* Taxonomy for request: tags */
		register_taxonomy_for_object_type( 'post_tag', 'request' );

		/* Taxonomy for news: news categories */
		register_taxonomy( 'news_cat', 'news', [
			'show_in_rest' => true,
			'hierarchical' => true,
			'label'        => __( 'Categories', 'wpjobster' )
		]);

		/* Taxonomy for news: tags */
		register_taxonomy_for_object_type( 'post_tag', 'news' );

		/* Add support for job post type */
		add_post_type_support( 'job', 'author' );
	}
}

add_action( 'admin_init', 'wpj_add_menu_separator' );
function wpj_add_menu_separator( $position ) {
	global $menu;

	$menu[29] = [
		0 => '',
		1 => 'read',
		2 => 'separator29',
		3 => '',
		4 => 'wp-menu-separator'
	];

	ksort( $menu );
}

add_filter( 'request', 'wpj_feed_request' );
if ( ! function_exists( 'wpj_feed_request' ) ) {
	function wpj_feed_request( $qv ) {
		if ( isset( $qv['feed'] ) ) {
			$qv['post_type'] = get_post_types( [ 'name' => 'job' ] );
		}

		return $qv;
	}
}

// Show only job posts
add_filter( 'pre_get_posts', 'wpj_set_job_post_type' );
if ( ! function_exists( 'wpj_set_job_post_type' ) ) {
	function wpj_set_job_post_type( $query ) {
		if ( is_home() && $query->is_main_query() ) {
			$query->set( 'post_type', [ 'job' ] );
		}

		return $query;
	}
}

// Show only active job posts from page builder query
add_filter( 'pre_get_posts', 'wpj_set_job_active_meta_query' );
if ( ! function_exists( 'wpj_set_job_active_meta_query' ) ) {
	function wpj_set_job_active_meta_query( $query ) {
		if (
			$query->get( 'post_type' ) == 'job'
			&& $query->get( 'post_status' ) == 'publish'
			&& ! $query->get( 'meta_query' )
		) {
			if (
				is_array( $query->get( 'post__not_in' ) )
				&& in_array( get_option( 'page_on_front' ), $query->get( 'post__not_in' ) )
			) {
				$query->set( 'meta_query', [
					[
						'key'     => 'active',
						'value'   => '1',
						'compare' => '='
					]
				] );

			}
		}

		return $query;
	}
}

add_action( 'pre_get_posts', 'wpj_allow_author_to_view_draft_post' );
if ( ! function_exists( 'wpj_allow_author_to_view_draft_post' ) ) {
	function wpj_allow_author_to_view_draft_post( $query ) {
		if ( get_current_user_id() == get_post_field( 'post_author', $query->query_vars['p'] ) ) {
			if ( isset( $_GET['post_type'] ) && ( $_GET['post_type'] == 'request' || $_GET['post_type'] == 'job' ) && ( isset( $_GET['p'] ) && $_GET['p'] ) ) {
				$query->set( 'post_status', [ 'publish', 'draft', 'pending', 'inherit' ] );
			}
		}
	}
}