<?php

// Skip wp_redirect() if currently editing the page with a known page builder
add_filter( 'wp_redirect', 'wpj_redirect_pagebuilder_filter', 10, 2 );
if ( ! function_exists( 'wpj_redirect_pagebuilder_filter' ) ) {
	function wpj_redirect_pagebuilder_filter( $location, $status ) {
		// check first if admin is logged in
		if ( ( function_exists( 'is_user_logged_in' ) && is_user_logged_in() )
			&& ( function_exists( 'current_user_can' ) && current_user_can( 'manage_options' ) )
		) {
			if ( wpj_is_pagebuilder_editor() ) $location = '';
		}

		return $location;
	}
}

// Homepage switch while logged in
add_filter( 'pre_option_page_on_front', 'wpj_page_on_front_logged_in' );
if ( ! function_exists( 'wpj_page_on_front_logged_in' ) ) {
	function wpj_page_on_front_logged_in( $id ) {
		$homepage_logged_in = apply_filters( 'wpj_main_page_url_user_filter', wpj_get_option( 'main_page_url_user' ) );

		if (
			is_user_logged_in()
			&& $homepage_logged_in
			&& ! is_admin()
			&& ! wpj_is_pagebuilder_editor()
			&& ! get_query_var( 'pg' )
		) {
			return $homepage_logged_in;
		}

		return $id;
	}
}

// Authentication custom pages redirect
add_action( 'init', 'wpj_authentication_custom_pages_redirect' );
if ( ! function_exists( 'wpj_authentication_custom_pages_redirect' ) ) {
	function wpj_authentication_custom_pages_redirect() {
		// Login
		if (
			wpj_get_option( 'wpjobster_login_page_id' )
			&& $GLOBALS['pagenow'] === 'wp-login.php' && ( ! WPJ_Form::get( 'action' ) || WPJ_Form::get( 'action' ) == 'login' )
			&& $_SERVER['REQUEST_METHOD'] == 'GET'
			&& empty( $_REQUEST )
		) {

			if ( isset( $_REQUEST['redirect_to'] ) )
				$login_page = get_permalink( wpj_get_option( 'wpjobster_login_page_id' ) ) . '?redirect_to=' . $_REQUEST['redirect_to'];

			else
				$login_page = get_permalink( wpj_get_option( 'wpjobster_login_page_id' ) );

			wp_redirect( $login_page ); exit;
		}

		// Register
		if (
			wpj_get_option( 'wpjobster_register_page_id' )
			&& $GLOBALS['pagenow'] === 'wp-login.php' && WPJ_Form::get( 'action' ) == 'register'
			&& $_SERVER['REQUEST_METHOD'] == 'GET'
			&& empty( $_REQUEST )
		) {
			if ( isset( $_REQUEST['redirect_to'] ) )
				$login_page = get_permalink( wpj_get_option( 'wpjobster_register_page_id' ) ) . '?redirect_to=' . $_REQUEST['redirect_to'];

			else
				$login_page = get_permalink( wpj_get_option( 'wpjobster_register_page_id' ) );

			wp_redirect( $login_page ); exit;
		}

		// Lost password
		if (
			wpj_get_option( 'wpjobster_forgot_password_page_id' )
			&& $GLOBALS['pagenow'] === 'wp-login.php' && WPJ_Form::get( 'action' ) == 'lostpassword'
			&& $_SERVER['REQUEST_METHOD'] == 'GET'
			&& empty( $_REQUEST )
		) {
			if ( isset( $_REQUEST['redirect_to'] ) )
				$login_page = get_permalink( wpj_get_option( 'wpjobster_forgot_password_page_id' ) ) . '?redirect_to=' . $_REQUEST['redirect_to'];

			else
				$login_page = get_permalink( wpj_get_option( 'wpjobster_forgot_password_page_id' ) );

			wp_redirect( $login_page ); exit;
		}

		// Redirect after registration
		if ( ! empty( $_REQUEST['checkemail'] ) ) {
			wp_redirect( wpj_register_redirect() ); exit;
		}
	}
}

// Login user after registration
add_action( 'user_register', 'wpj_auto_login_new_user', 11 );
if ( ! function_exists( 'wpj_auto_login_new_user' ) ) {
	function wpj_auto_login_new_user( $user_id ) {
		if ( ! is_user_logged_in() ) {
			wp_set_current_user( $user_id );
			wp_set_auth_cookie( $user_id, false, is_ssl() );
		}
	}
}

// Register redirect
add_filter( 'registration_redirect', 'wpj_register_redirect', 999 );
if ( ! function_exists( 'wpj_register_redirect' ) ) {
	function wpj_register_redirect( $redirect = '' ) {
		// Redirect to saved option
		$redirect_to = wpj_get_option( 'wpjobster_register_redirection_page' );

		// Redirect to last page before register
		if ( isset( $_REQUEST['redirect_to'] ) )
			$redirect_to = $_REQUEST['redirect_to'] ? $_REQUEST['redirect_to'] : ( $redirect_to >= 1 ? get_permalink( $redirect_to ) : home_url() );

		else
			$redirect_to = $redirect_to >= 1 ? get_permalink( $redirect_to ) : home_url();

		// Redirect to first created job
		if ( wpj_get_option( 'wpjobster_enable_shoutout_offer_number' ) == 'yes' && wpj_get_user_account_type( get_current_user_id() ) == 'seller' ) {
			$redirect_to = add_query_arg( ['jobid' => get_user_meta( get_current_user_id(), 'first_job', true ), 'action' => 'edit-job'], get_permalink( wpj_get_option( 'wpjobster_post_new_page_id' ) ) );
		}

		// Redirect to filter
		$redirect_to = apply_filters( 'wpj_register_redirect_url_filter', $redirect_to );

		if ( $redirect_to != get_permalink( wpj_get_option( 'main_page_url' ) ) ) {
			$redirect = $redirect_to;
		}

		return apply_filters( 'wpj_register_redirect_url_filter', $redirect );
	}
}

// Login redirect
add_filter( 'login_redirect', 'wpj_login_redirect', 999 );
if ( ! function_exists( 'wpj_login_redirect' ) ) {
	function wpj_login_redirect( $redirect_to = '', $request = '', $user = null ) {
		$redirect_to = wpj_get_option( 'wpjobster_login_redirection_page' );

		if ( isset( $_REQUEST['redirect_to'] ) )
			$redirect_to = $_REQUEST['redirect_to'] ? $_REQUEST['redirect_to'] : home_url();

		else
			$redirect_to = $redirect_to >= 1 ? get_permalink( $redirect_to ) : ( $redirect_to >= 1 ? get_permalink( $redirect_to ) : home_url() );

		return apply_filters( 'wpj_login_redirect_url_filter', $redirect_to );
	}
}

// Password reset redirect
add_action( 'password_reset', 'wpj_lost_password_reset_redirect', 10, 2 );
if ( ! function_exists( 'wpj_lost_password_reset_redirect' ) ) {
	function wpj_lost_password_reset_redirect( $user, $new_pass ) {
		wp_set_password( $new_pass, $user->ID );

		wp_redirect( wpj_get_login_link() );

		exit;
	}
}

add_action( 'template_redirect', 'wpj_template_redirect', 3 );
if ( ! function_exists( 'wpj_template_redirect' ) ) {
	function wpj_template_redirect() {
		global $post;

		$page_id = isset( $post->ID ) ? $post->ID : '';

		// AIO
		if (
			wpj_get_option( 'wpjobster_login_page_id' )
			&& ! is_user_logged_in()
			&& ( wpj_is_page( 'wpjobster_new_ticket_page_id' ) || wpj_is_page( 'wpjobster_ticket_list_page_id' ) || wpj_is_page( 'wpjobster_single_ticket_page_id' ) )
		) {
			$redirect_url = get_permalink( wpj_get_option( 'wpjobster_login_page_id' ) ) . '?redirect_to=' . urlencode( get_permalink() );
		}

		// Pages that are allowed if phone number or email is still not verified
		$admin_custom_allowed_pages = wpj_get_option( 'wpjobster_locked_allowed_pages' );

		if ( wpj_get_user_account_type() == 'seller' ) {
			$allowed_pages_id = [
				wpj_get_option( 'wpjobster_my_account_page_id' ),
				wpj_get_option( 'wpjobster_my_account_personal_info_page_id' )
			];

		} else {
			$allowed_pages_id = [
				wpj_get_option( 'wpjobster_my_account_shopping_page_id' ),
				wpj_get_option( 'wpjobster_my_account_personal_info_page_id' ),
				wpj_get_option( 'wpjobster_my_account_sales_page_id' ),
				wpj_get_option( 'wpjobster_account_verification_page_id' )
			];

		}

		if ( is_array( $admin_custom_allowed_pages ) && $admin_custom_allowed_pages ) {
			$allowed_pages_id = array_merge( $allowed_pages_id, $admin_custom_allowed_pages );
			$allowed_pages_id = array_unique( $allowed_pages_id );
		}

		// Checking current page is not sending verification code
		if ( ! wpj_is_page( wpj_get_option( 'wpjobster_verify_email_page_id' ) )
			&& ! wpj_is_page( wpj_get_option( 'wpjobster_verify_phone_page_id' ) )
		) {
			// Lock to allowed_pages until phone number is verified
			if ( is_user_logged_in() ) {
				$user_cell_number = get_user_meta( get_current_user_id(), 'cell_number' );

				$is_verify_number = wpj_get_option( 'wpjobster_verify_phone_numbers' );

				if ( $is_verify_number == 'yes'
					&& get_user_meta( get_current_user_id(), 'uz_phone_verification', true ) != 1
					&& wpj_get_option( 'wpjobster_lock_verify_phone_numbers' ) == 'yes'
					&& ! in_array( $page_id, $allowed_pages_id )
				) {
					if ( wpj_get_user_account_type() == "seller" ) {
						$redirect_url = get_permalink( wpj_get_option( 'wpjobster_my_account_page_id' ) );

					} else {
						$redirect_url = get_permalink( wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) );

					}
				}
			}

			// Lock to allowed_pages until email is verified
			if ( is_user_logged_in() ) {
				$is_email_address = wpj_get_option( 'wpjobster_lock_verify_email_address' );

				if ( $is_email_address == 'yes'
					&& wpj_get_option( 'wpjobster_verify_email' ) != 'no'
					&& get_user_meta( get_current_user_id(), 'uz_email_verification', true ) != 1
					&& ! in_array( $page_id, $allowed_pages_id )
				) {
					if ( wpj_get_user_account_type() == "seller" ) {
						$redirect_url = get_permalink( wpj_get_option( 'wpjobster_my_account_page_id' ) );

					} else {
						$redirect_url = get_permalink( wpj_get_option( 'wpjobster_my_account_shopping_page_id' ) );

					}
				}
			}
		}

		// Only logged-in users should be able to see offers
		if ( ! is_user_logged_in() && ( ( isset( $post->post_type ) && $post->post_type == 'offer' ) || is_post_type_archive( 'offer' ) ) ) {
			$redirect_url = get_bloginfo( 'url' );
		}

		$redirect_uri = isset( $redirect_url ) ? $redirect_url : false;
		$redirect_uri = apply_filters( 'wpj_theme_redirects_filter', $redirect_uri );

		if ( $redirect_uri ) {
			if ( wp_redirect( $redirect_uri ) ) { exit; }
		}
	}
}