<?php
add_action( 'init', 'wpj_rewrite_rules', 10, 0 );
if ( ! function_exists( 'wpj_rewrite_rules' ) ) {
	function wpj_rewrite_rules() {

		/* SLUGS */

		// User account slugs
		$user_account_slugs    = [];
		$user_account_pages_id = wpj_get_user_account_pages();

		if ( $user_account_pages_id ) {
			foreach ( $user_account_pages_id as $page_id ) {
				$post_page = get_post( $page_id );

				if ( isset( $post_page->post_name ) ) {
					if ( $post_page->post_parent > 0 ) {
						$parent_post = get_post( $post_page->post_parent );
						$parent_slug = isset( $parent_post->post_name ) ? $parent_post->post_name : '';

						$user_account_slugs[] = $parent_slug . '/' . $post_page->post_name;

					} else {
						$user_account_slugs[] = $post_page->post_name;

					}
				}
			}
		}

		$user_account_slugs = apply_filters( 'wpj_theme_user_account_slugs_filter', $user_account_slugs );

		// Post type category slugs
		$post_category_slugs = [
			'job_cat'     => wpj_get_job_category_permalink(),
			'request_cat' => wpj_get_request_category_permalink(),
			'news_cat'    => wpj_get_news_category_permalink()
		];

		// Homepage Logged In
		if ( ! empty( apply_filters( 'wpj_main_page_url_user_filter', wpj_get_option( 'main_page_url_user' ) ) ) ) {
			$post                   = get_post( apply_filters( 'wpj_main_page_url_user_filter', wpj_get_option( 'main_page_url_user' ) ) );
			$homepage_loggedin_slug = ! empty( $post->post_name ) ? $post->post_name : 'homepage-loggedin';
		} else $homepage_loggedin_slug = 'homepage-loggedin';

		// My account slug
		if ( ! empty( wpj_get_option( 'wpjobster_my_account_page_id' ) ) ) {
			$post            = get_post( wpj_get_option( 'wpjobster_my_account_page_id' ) );
			$my_account_slug = ! empty( $post->post_name ) ? $post->post_name : 'my-account';
		} else $my_account_slug = 'my-account';

		// PM slug
		if ( ! empty( wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ) ) ) {
			$post    = get_post( wpj_get_option( 'wpjobster_my_account_priv_mess_page_id' ) );
			$pm_slug = ! empty( $post->post_name ) ? $post->post_name : 'private-messages';
		} else $pm_slug = 'private-messages';

		// User profile slug
		if ( ! empty( wpj_get_option( 'wpjobster_user_profile_page_id' ) ) ) {
			$post              = get_post( wpj_get_option( 'wpjobster_user_profile_page_id' ) );
			$user_profile_slug = ! empty( $post->post_name ) ? $post->post_name : 'user-profile';
		} else $user_profile_slug = 'user-profile';

		// Feature slug
		if ( ! empty( wpj_get_option( 'wpjobster_feature_page_id' ) ) ) {
			$post             = get_post( wpj_get_option( 'wpjobster_feature_page_id' ) );
			$feature_job_slug = ! empty( $post->post_name ) ? $post->post_name : 'feature-job';
		} else $feature_job_slug = 'feature-job';

		// Order slug
		if ( ! empty( wpj_get_option( 'wpjobster_order_page_id' ) ) ) {
			$post       = get_post( wpj_get_option( 'wpjobster_order_page_id' ) );
			$order_slug = ! empty( $post->post_name ) ? $post->post_name : 'order';
		} else $order_slug = 'order';

		// Topup order slug
		if ( ! empty( wpj_get_option( 'wpjobster_topup_order_page_id' ) ) ) {
			$post             = get_post( wpj_get_option( 'wpjobster_topup_order_page_id' ) );
			$topup_order_slug = ! empty( $post->post_name ) ? $post->post_name : 'topup-order';
		} else $topup_order_slug = 'topup-order';

		/* RULES */

		add_rewrite_rule( 'page/([^/]+)/?$', 'index.php?paged=$matches[1]', 'top' );

		// Homepage Logged In
		add_rewrite_rule( $homepage_loggedin_slug . '/([^/]+)/?$', 'index.php?pagename=' . $homepage_loggedin_slug . '&pg=$matches[1]', 'top' );

		// User account
		if ( $user_account_slugs ) {
			foreach ( $user_account_slugs as $post_key => $post_slug ) {
				add_rewrite_rule( $post_slug . '/?([^/]*)/page/?([0-9]{1,})/?$', 'index.php?pagename=' . $post_slug . '&pg=$matches[1]&paged=$matches[2]', 'top' );
				add_rewrite_rule( $post_slug . '/?([^/]*)/?$', 'index.php?pagename=' . $post_slug . '&pg=$matches[1]', 'top' );
			}
		}

		// PM
		add_rewrite_rule( $my_account_slug . '/' . $pm_slug . '/([\w+]*)/([\w+]*)', 'index.php?pagename=' . $my_account_slug . '/' . $pm_slug . '&pg=$matches[1]&message_id=$matches[2]', 'top' );

		// User Profile
		add_rewrite_rule( $user_profile_slug . '/([^/]+)/?$', 'index.php?pagename=' . $user_profile_slug . '&username=$matches[1]', 'top' );

		// Feature Job
		add_rewrite_rule( $feature_job_slug . '/([^/]+)/?$', 'index.php?pagename=' . $feature_job_slug . '&jobid=$matches[1]', 'top' );

		// Order
		add_rewrite_rule( $order_slug . '/([^/]+)/?$', 'index.php?pagename=' . $order_slug . '&oid=$matches[1]', 'top' );

		// Topup Order
		add_rewrite_rule( $topup_order_slug . '/([^/]+)/?$', 'index.php?pagename=' . $topup_order_slug . '&oid=$matches[1]', 'top' );

		// Category
		foreach ( $post_category_slugs as $category_key => $category_slug ) {
			add_rewrite_rule( $category_slug . '/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$', 'index.php?' . $category_key . '=$matches[1]&feed=$matches[2]', 'top' );
			add_rewrite_rule( $category_slug . '/([^/]+)/(feed|rdf|rss|rss2|atom)/?$', 'index.php?' . $category_key . '=$matches[1]&feed=$matches[2]', 'top' );
			add_rewrite_rule( $category_slug . '/([^/]+)/page/?([0-9]{1,})/?$', 'index.php?' . $category_key . '=$matches[1]&paged=$matches[2]', 'top' );
			add_rewrite_rule( $category_slug . '/([^/]+)/?$', 'index.php?' . $category_key . '=$matches[1]', 'top' );
		}
	}
}