<?php
add_action( 'admin_enqueue_scripts', 'wpj_enqueue_assets', 10 );
add_action( 'wp_enqueue_scripts', 'wpj_enqueue_assets', 10 );
if ( ! function_exists( 'wpj_enqueue_assets' ) ) {
	function wpj_enqueue_assets() {
		// Common Styles
		wpj_include_assets( get_template_directory() . '/assets/css/vendor/common', get_template_directory_uri() . '/assets/css/vendor/common', 'css' );
		wpj_include_assets( get_template_directory() . '/assets/css/common', get_template_directory_uri() . '/assets/css/common', 'css' );

		// Common Scripts
		wp_enqueue_script( 'wpj-hooks-script', get_template_directory_uri() . '/assets/js/vendor/common/hooks.js', [ 'jquery' ], wpjobster_VERSION, true );
		wp_enqueue_script( 'wpj-moment-script', get_template_directory_uri() . '/assets/js/vendor/common/moment.js', [ 'jquery' ], wpjobster_VERSION, true );
		wpj_include_assets( get_template_directory() . '/assets/js/vendor/common', get_template_directory_uri() . '/assets/js/vendor/common', 'js', [
			'hooks',
			'moment'
		], true );

		wp_enqueue_script( 'wpj-front-scripts', get_template_directory_uri() . '/assets/js/common/helpers.js', [ 'jquery' ], wpjobster_VERSION, true );
		wpj_include_assets( get_template_directory() . '/assets/js/common', get_template_directory_uri() . '/assets/js/common', 'js', [ 'helpers' ], true );

		if ( is_admin() ) {
			// Admin Styles
			wpj_include_assets( get_template_directory() . '/assets/css/vendor/admin', get_template_directory_uri() . '/assets/css/vendor/admin', 'css' );
			wpj_include_assets( get_template_directory() . '/assets/css/admin', get_template_directory_uri() . '/assets/css/admin', 'css' );

			// Admin Scripts
			wp_enqueue_script( 'wpj-daterangepicker-script', get_template_directory_uri() . '/assets/js/vendor/admin/daterangepicker.js', [ 'jquery' ], wpjobster_VERSION, true );
			wpj_include_assets( get_template_directory() . '/assets/js/vendor/admin', get_template_directory_uri() . '/assets/js/vendor/admin', 'js', [ 'daterangepicker' ], true );

			wpj_include_assets( get_template_directory() . '/assets/js/admin', get_template_directory_uri() . '/assets/js/admin', 'js', [], true );
			wpj_include_assets( get_template_directory() . '/assets/js/extensions/admin', get_template_directory_uri() . '/assets/js/extensions/admin', 'js', [], true );

		} else {
			// Front Styles
			wp_enqueue_style( 'wpj-featherlight-style', get_template_directory_uri() . '/assets/css/vendor/front/featherlight.css', [], wpjobster_VERSION, 'all' );
			wpj_include_assets( get_template_directory() . '/assets/css/vendor/front', get_template_directory_uri() . '/assets/css/vendor/front', 'css', [ 'featherlight' ] );

			if ( is_rtl() ) { // RTL
				wp_enqueue_style( 'wpj-front-rtl-style', get_template_directory_uri() . '/assets/min/wpjobster-front.rtl.css', [], wpjobster_VERSION, 'all' );

			} else { // LTR
				wp_enqueue_style( 'wpj-semantic-custom-style', get_template_directory_uri() . '/assets/css/front/semantic-custom.css', [], wpjobster_VERSION, 'all' );
				wpj_include_assets( get_template_directory() . '/assets/css/front', get_template_directory_uri() . '/assets/css/front', 'css', [
					'reset',
					'semantic-custom'
				] );
			}

			// Front SCSS Styles
			if ( is_rtl() ) {
				wp_enqueue_style( 'wpj-front-scss-ltr-style', get_template_directory_uri() . '/assets/min/wpjobster-front-scss.rtl.css', [], wpjobster_VERSION, 'all' );
			} else {
				wp_enqueue_style( 'wpj-front-scss-ltr-style', get_template_directory_uri() . '/assets/min/wpjobster-front-scss.ltr.css', [], wpjobster_VERSION, 'all' );
			}

			// Front REDUX
			$upload_dir = wp_upload_dir();

			if ( file_exists( $upload_dir['basedir'] . '/wpjobster/redux.css' ) ) {
				wp_enqueue_style( 'redux-css', $upload_dir['baseurl'] . '/wpjobster/redux.css', [], wpj_get_option( 'wpj_last_redux_css_compiled' ) );
			} else {
				wp_enqueue_style( 'redux-css', get_template_directory_uri() . '/assets/min/redux.css', [], wpjobster_VERSION );
			}

			// Front Scripts
			wp_enqueue_script( 'wpj-modernizr-touch-script', get_template_directory_uri() . '/assets/js/vendor/front/modernizr.touch.js', [ 'jquery' ], wpjobster_VERSION, true );
			wp_enqueue_script( 'wpj-featherlight-script', get_template_directory_uri() . '/assets/js/vendor/front/featherlight.js', [ 'jquery' ], wpjobster_VERSION, true );
			wpj_include_assets( get_template_directory() . '/assets/js/vendor/front', get_template_directory_uri() . '/assets/js/vendor/front', 'js', [
				'modernizr',
				'featherlight'
			], true );

			wp_enqueue_script( 'wpj-initializations-script', get_template_directory_uri() . '/assets/js/front/initializations.js', [ 'jquery' ], wpjobster_VERSION, true );
			wpj_include_assets( get_template_directory() . '/assets/js/front', get_template_directory_uri() . '/assets/js/front', 'js', [ 'initializations' ], true );
			wpj_include_assets( get_template_directory() . '/assets/js/extensions/front', get_template_directory_uri() . '/assets/js/extensions/front', 'js', [ 'initializations' ], true );

		}
	}
}

// Include asset file
if ( ! function_exists( 'wpj_include_assets' ) ) {
	function wpj_include_assets( $path = '', $uri = '', $type = 'css', $exclude_array = [], $in_footer = true ) {
		$files_arr = wpj_get_folder_files( $path );
		$folder_name = pathinfo( $path, PATHINFO_FILENAME );

		if ( $files_arr ) {
			foreach ( $files_arr as $key => $file ) {
				$name = pathinfo( $file, PATHINFO_FILENAME );
				$ext  = pathinfo( $file, PATHINFO_EXTENSION );

				if ( $name && $ext ) {
					if ( $type == 'js' && $ext == 'js' ) {
						wp_enqueue_script( 'wpj-' . $folder_name . '-' . $name . '-scripts', $uri . '/' . $name . '.js', [
							'jquery',
							'underscore'
						], wpjobster_VERSION, $in_footer );

					} elseif ( $type == 'css' && $ext == 'css' ) {
						if ( ! in_array( $name, $exclude_array ) ) {
							wp_enqueue_style( 'wpj-' . $folder_name . '-' . $name . '-stylesheet', $uri . '/' . $name . '.css', [], wpjobster_VERSION );
						}

					}
				}
			}
		}
	}
}