<?php
add_action( 'admin_enqueue_scripts', 'wpj_enqueue_assets', 10 );
add_action( 'wp_enqueue_scripts', 'wpj_enqueue_assets', 10 );
if ( ! function_exists( 'wpj_enqueue_assets' ) ) {
	function wpj_enqueue_assets() {
		if ( is_admin() ) { // ADMIN
			wp_enqueue_style( 'wpj-admin-styles', get_template_directory_uri() . '/assets/min/wpjobster-admin.min.css', [], wpjobster_VERSION, 'all' );
			wp_enqueue_script( 'wpj-admin-scripts', get_template_directory_uri() . '/assets/min/wpjobster-admin.min.js', [ 'jquery' ], wpjobster_VERSION, true );

		} else { // FRONT
			if ( is_rtl() ) {
				wp_enqueue_style( 'wpj-front-styles', get_template_directory_uri() . '/assets/min/wpjobster-front.rtl.min.css', [], wpjobster_VERSION, 'all' );
			} else {
				wp_enqueue_style( 'wpj-front-styles', get_template_directory_uri() . '/assets/min/wpjobster-front.ltr.min.css', [], wpjobster_VERSION, 'all' );
			}

			if ( ! isset( $_REQUEST['_locale'] ) || ( isset( $_REQUEST['_locale'] ) && $_REQUEST['_locale'] != 'user' ) ) {
				wp_enqueue_script( 'wpj-front-scripts', get_template_directory_uri() . '/assets/min/wpjobster-front.min.js', [ 'jquery' ], wpjobster_VERSION, true );
			}

			$upload_dir = wp_upload_dir();

			if ( file_exists( $upload_dir['basedir'] . '/wpjobster/redux.css' ) ) {
				wp_enqueue_style( 'redux-css', $upload_dir['baseurl'] . '/wpjobster/redux.css', [], wpj_get_option( 'wpj_last_redux_css_compiled' ) );
			} else {
				wp_enqueue_style( 'redux-css', get_template_directory_uri() . '/assets/min/redux.css', [], wpjobster_VERSION );
			}
		}
	}
}