<?php
if ( defined( 'WPJ_ASSETS_DEBUG' ) && WPJ_ASSETS_DEBUG == true ) {
	include_once get_template_directory() . '/includes/theme-setup/scripts-and-styles-dev.php';
} else {
	include_once get_template_directory() . '/includes/theme-setup/scripts-and-styles-live.php';
}

// Include libraries
add_action( 'admin_enqueue_scripts', 'wpj_enqueue_libraries_assets', 9 );
add_action( 'wp_enqueue_scripts', 'wpj_enqueue_libraries_assets', 9 );
if ( ! function_exists( 'wpj_enqueue_libraries_assets' ) ) {
	function wpj_enqueue_libraries_assets() {
		// Google Maps
		if ( wpj_get_option( 'wpjobster_location_api_provider' ) == 'google' && wpj_get_option( 'wpjobster_google_maps_api_key' ) ) {
			wp_enqueue_script( 'maps-api', 'https://maps.googleapis.com/maps/api/js?key=' . wpj_get_option( 'wpjobster_google_maps_api_key' ) . '&v=3.exp&libraries=places', [ 'jquery' ], false, true );
		}

		if ( is_admin() ) { // ADMIN

			// jQuery Libraries
			wp_enqueue_script( "jquery-ui-widget" );
			wp_enqueue_script( "jquery-ui-mouse" );
			wp_enqueue_script( "jquery-ui-tabs" );
			wp_enqueue_script( "jquery-ui-datepicker" );
			wp_enqueue_script( "jquery-ui-sortable" );

			// Semantic UI
			wp_enqueue_style( 'semantic-ui-icon', get_template_directory_uri() . '/vendor/semantic-ui-admin/icon.min.css', [], '2.4.1' );
			wp_enqueue_style( 'semantic-ui-accordion-style', get_template_directory_uri() . '/vendor/semantic-ui-admin/accordion.min.css', [], '2.4.1' );
			wp_enqueue_script( 'semantic-ui-accordion-script', get_template_directory_uri() . '/vendor/semantic-ui-admin/accordion.min.js', [ 'jquery' ], '2.4.1', true );

		} else { // FRONT

			// jQuery Libraries
			wp_enqueue_script( 'jquery-form' );
			wp_enqueue_script( 'jquery-touch-punch' );
			wp_enqueue_script( 'jquery-ui-autocomplete' );
			wp_enqueue_script( 'jquery-ui-slider' );
			wp_enqueue_script( 'jquery-ui-sortable' );

			wp_enqueue_script( 'jquery-effects-blind' );
			wp_enqueue_script( 'jquery-effects-bounce' );
			wp_enqueue_script( 'jquery-effects-clip' );
			wp_enqueue_script( 'jquery-effects-drop' );
			wp_enqueue_script( 'jquery-effects-explode' );
			wp_enqueue_script( 'jquery-effects-fade' );
			wp_enqueue_script( 'jquery-effects-fold' );
			wp_enqueue_script( 'jquery-effects-highlight' );
			wp_enqueue_script( 'jquery-effects-puff' );
			wp_enqueue_script( 'jquery-effects-pulsate' );
			wp_enqueue_script( 'jquery-effects-scale' );
			wp_enqueue_script( 'jquery-effects-shake' );
			wp_enqueue_script( 'jquery-effects-size' );
			wp_enqueue_script( 'jquery-effects-slide' );
			wp_enqueue_script( 'jquery-effects-transfer' );

			// Semantic UI
			$upload_dir = wp_upload_dir();

			if ( file_exists( $upload_dir['basedir'] . '/wpjobster/semantic.css' ) ) {
				wp_enqueue_style( 'semantic-ui-css', $upload_dir['baseurl'] . '/wpjobster/semantic.css', [], wpj_get_option( 'wpj_last_css_compiled' ) );
			} else {
				wp_enqueue_style( 'semantic-ui-css', get_template_directory_uri() . '/vendor/semantic-ui/dist/semantic.min.css', [], '2.4.1' );
			}

			if ( is_rtl() ) {
				wp_enqueue_style( 'semantic-ui-css-rtl', get_template_directory_uri() . '/vendor/semantic-ui/dist/semantic.rtl.autogenerated.css', [], '2.4.1' );
			}

			wp_enqueue_script( 'semantic-ui-js', get_template_directory_uri() . '/vendor/semantic-ui/dist/semantic.min.js', [ 'jquery' ], '2.4.1', true );
		}
	}
}

// Delete type attribute from scripts and styles
add_filter( 'style_loader_tag', 'wpj_remove_type_attr_from_script_and_style', 10, 2 );
add_filter( 'script_loader_tag', 'wpj_remove_type_attr_from_script_and_style', 10, 2 );
if ( ! function_exists( 'wpj_remove_type_attr_from_script_and_style' ) ) {
	function wpj_remove_type_attr_from_script_and_style( $tag, $handle ) {
		return preg_replace( "/type=['\"]text\/(javascript|css)['\"]/", '', $tag );
	}
}

// Defer Scripts
add_filter( 'clean_url', 'wpj_defer_parsing_of_js', 11, 1 );
if ( ! function_exists( 'wpj_defer_parsing_of_js' ) ) {
	function wpj_defer_parsing_of_js( $url ) {
		$jobster_design = wpj_get_design_option();

		if ( ! empty( $jobster_design['enable_js_defer'] ) ) {
			$exclude_files = apply_filters( 'wpj_js_exclude_defer_filter', [
				'jquery.js',
				'jquery.min.js',
				'i18n.min.js',
				'hooks.min.js',
				'tinymce.min.js'
			] );

			$apostrophe_files = apply_filters( 'wpj_js_defer_apostrophe_filter', [
				'wp-polyfill-fetch.js',
				'wp-polyfill-fetch.min.js',
				'wp-polyfill-node-contains.js',
				'wp-polyfill-node-contains.min.js',
				'wp-polyfill-formdata.js',
				'wp-polyfill-formdata.min.js',
				'wp-polyfill-element-closest.js',
				'wp-polyfill-element-closest.min.js',
				'wp-polyfill-dom-rect.js',
				'wp-polyfill-dom-rect.min.js',
				'wp-polyfill-object-fit.js',
				'wp-polyfill-object-fit.min.js',
				'wp-polyfill-url.js',
				'wp-polyfill-url.min.js',
			] );

			if ( ! is_admin() ) {

				if ( false === strpos( $url, '.js' ) ) {
					return $url;
				}

				if ( $exclude_files ) {
					foreach ( $exclude_files as $file ) {
						if ( strpos( $url, $file ) ) {
							return $url;
						}
					}
				}

				if ( $apostrophe_files ) {
					foreach ( $apostrophe_files as $file ) {
						if ( strpos( $url, $file ) ) {
							return '$url" defer="defer';
						}
					}
				}

			} else {
				return $url;
			}

			return "$url' defer='defer";
		}

		return $url;
	}
}

// Defer Styles
add_filter( 'style_loader_tag', 'wpj_defer_parsing_of_css', 10, 4 );
if ( ! function_exists( 'wpj_defer_parsing_of_css' ) ) {
	function wpj_defer_parsing_of_css( $html, $handle, $href, $media ) {
		$jobster_design = wpj_get_design_option();

		if ( ! empty( $jobster_design['enable_css_preload'] ) && $jobster_design['enable_css_preload'] == true ) {
			if ( is_admin() ) {
				return $html;
			}

			$exclude_files = apply_filters( 'wpj_css_exclude_preloader_filter', [
				'preview.css',
				'semantic.css',
				'semantic.min.css'
			] );

			if ( isset( $_SERVER['HTTP_USER_AGENT'] ) ) {
				$agent = $_SERVER['HTTP_USER_AGENT'];

				if ( strlen( strstr( $agent, 'Firefox' ) ) > 0 ) {
					$exclude_files[] = 'rs6.css';
					$exclude_files[] = 'dropzone.css';
					$exclude_files[] = 'dropzone.min.css';
				}
			}

			if ( $exclude_files ) {
				foreach ( $exclude_files as $file ) {
					if ( strpos( $html, $file ) ) {
						return $html;
					}
				}
			}

			$html = '<link rel="preload" href="' . $href . '" as="style" onload="this.onload=null;this.rel=\'stylesheet\'" />';
			$html .= '<noscript><link rel="stylesheet" href="' . $href . '"></noscript>';

			return $html;
		}

		return $html;
	}
}