<?php
add_filter( 'login_title', 'wpj_authentication_title' );
if ( ! function_exists( 'wpj_authentication_title' ) ) {
	function wpj_authentication_title( $login_title ) {
		return str_replace( [ ' &lsaquo;', ' &#8212; WordPress' ], [ ' &lsaquo;', '' ], $login_title );
	}
}

add_action( 'pre_get_posts', 'wpj_setup_title', 10, 1 );
if ( ! function_exists( 'wpj_setup_title' ) ) {
	function wpj_setup_title( $query ) {
		// hook custom titles for custom pages, where wp_query is useless
		// hook Yoast SEO titles for regular WP pages

		if (
			( isset( $query->queried_object->ID ) && $query->queried_object->ID == wpj_get_option( 'wpjobster_user_profile_page_id' ) )
			|| ( isset( $query->queried_object->ID ) && $query->queried_object->ID == wpj_get_option( 'wpjobster_order_page_id' ) )
		) {
			add_filter( 'pre_get_document_title', 'wpj_custom_titles', 20 );
		}
	}
}

if ( ! function_exists( 'wpj_custom_titles' ) ) {
	function wpj_custom_titles( $title ) {
		global $wp_query;

		if ( wpj_get_option( 'wpjobster_order_page_id' ) && is_page( wpj_get_option( 'wpjobster_order_page_id' ) ) ) {
			if ( ! $title ) $title = get_the_title( wpj_get_option( 'wpjobster_order_page_id' ) );

			$custom_title = sprintf( __( "Transaction #%s", "wpjobster" ), wpj_camouflage_oid( $wp_query->query_vars['oid'] ) );

		} elseif ( wpj_get_option( 'wpjobster_user_profile_page_id' ) && is_page( wpj_get_option( 'wpjobster_user_profile_page_id' ) ) ) {
			if ( ! $title ) $title = get_the_title( wpj_get_option( 'wpjobster_user_profile_page_id' ) );

			$user = isset( $wp_query->query_vars['username'] ) ? get_user_by( 'login', urldecode( $wp_query->query_vars['username'] ) ) : '';

			$custom_title = isset( $user->ID ) ? wpj_get_user_display_type( $user->ID ) : wpj_get_user_display_type( get_current_user_id() );

		}

		return isset( $custom_title ) && $custom_title ? $custom_title . ' &#8211; ' . get_bloginfo( 'name' ) : $title;
	}
}