<?php
add_action( 'widgets_init', 'wpj_widgets_init' );
if ( ! function_exists( 'wpj_widgets_init' ) ) {
	function wpj_widgets_init() {
		$jobster_design = wpj_get_design_option();

		$customizer_columns_select = ! empty( $jobster_design['select_number_cols'] ) ? $jobster_design['select_number_cols'] : 5;

		for ( $x = 1; $x <= $customizer_columns_select; $x++ ) {
			register_sidebar( [
				'name'          => 'Footer Widget ' . $x,
				'id'            => 'footer-widget-' . $x,
				'before_widget' => '<div class="chw-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="footer-widget-title-wrapper toggle-arrow js-toggle-arrow"><h2 class="chw-title">',
				'after_title'   => '</h2></div>',
			] );

			register_sidebar( [
				'name'          => 'Footer Widget ' . $x . ' Logged In',
				'id'            => 'footer-widget-' . $x . '-logged-in',
				'before_widget' => '<div class="chw-widget">',
				'after_widget'  => '</div>',
				'before_title'  => '<div class="footer-widget-title-wrapper toggle-arrow js-toggle-arrow"><h2 class="chw-title">',
				'after_title'   => '</h2></div>',
			] );
		}
	}
}

add_action( 'widgets_init', 'wpj_framework_init_widgets' );
if ( ! function_exists( 'wpj_framework_init_widgets' ) ) {
	function wpj_framework_init_widgets() {
		register_sidebar(
			[
				'name'          => __( 'wpjobster - Page Sidebar', 'wpjobster' ),
				'id'            => 'page-widgets-area',
				'description'   => __( 'This sidebar is placed on the default pages.', 'wpjobster' ),
				'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
				'after_widget'  => '</li>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			]
		);

		register_sidebar(
			[
				'name'          => __( 'wpjobster - Job Single', 'wpjobster' ),
				'id'            => 'single-job-widgets-area',
				'description'   => __( 'This sidebar is placed on the single job on the right bottom side.', 'wpjobster' ),
				'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
				'after_widget'  => '</li>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			]
		);

		register_sidebar(
			[
				'name'          => __( 'wpjobster - Categories Top', 'wpjobster', 'wpjobster' ),
				'id'            => 'category-top-widgets-area',
				'description'   => __( 'This sidebar is placed on the top side of the category pages.', 'wpjobster' ),
				'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
				'after_widget'  => '</li>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			]
		);

		register_sidebar(
			[
				'name'          => __( 'wpjobster - Categories Bottom', 'wpjobster', 'wpjobster' ),
				'id'            => 'category-bottom-widgets-area',
				'description'   => __( 'This sidebar is placed on the bottom side of the category pages.', 'wpjobster' ),
				'before_widget' => '<li id="%1$s" class="widget-container %2$s">',
				'after_widget'  => '</li>',
				'before_title'  => '<h3 class="widget-title">',
				'after_title'   => '</h3>'
			]
		);
	}
}