<?php

// File
if ( ! function_exists( 'wpj_get_folder_files' ) ) {
	function wpj_get_folder_files( $dir = '', $ret = [] ) {
		$dir   = $dir == '' ? dirname( __FILE__ ) : $dir;
		$files = @scandir( $dir );

		if ( ! empty( $files ) ) {
			foreach ( $files as $key => $filename ) {
				$path = realpath( $dir . DIRECTORY_SEPARATOR . $filename );

				if ( ! is_dir( $path ) ) {
					$ret[] = $path;

				} else if ( $filename != "." && $filename != ".." ) {
					wpj_get_folder_files( $path, $ret );

				}
			}
		}

		return $ret;
	}
}

// Shortcode
if ( ! function_exists( 'wpj_add_shortcode' ) ) {
	function wpj_add_shortcode( $tag, $func ) {
		if ( ! is_admin() ) {
			add_shortcode( $tag, $func );

		} else {
			return false;

		}
	}
}

// Query
if ( ! function_exists( 'wpj_get_query_results' ) ) {
	function wpj_get_query_results( $args ) {
		global $wpdb;

		$defaults = [
			'table'  => false,
			'fields' => 'DISTINCT *',
			'where'  => [],
			'group'  => '',
			'order'  => '',
			'limit'  => '',
			'offset' => '',
			'return' => 'results'
		];

		$args = wp_parse_args( $args, $defaults );

		if ( is_array( $args['table'] ) ) {
			$table = $wpdb->prefix . implode( ', ' . $wpdb->prefix, $args['table'] );

		} else {
			$table = $wpdb->prefix . $args['table'];

		}

		$where = '';

		if ( ! isset( $where['relation'] ) && ! empty( $args['where'] ) ) {
			$args['where'] = ['relation' => 'AND', 'fields' => $args['where']];
		}

		if ( ! empty( $args['where'] ) ) {
			foreach ( $args['where']['fields'] as $column => $value ) {
				if ( $column != 'fields_not_strings' && $column != 'fields_date' ) {
					$where .= sprintf( ' %s %s = "%s"', $args['where']['relation'], $column, $value );

				} elseif ( $column == 'fields_not_strings' ) {
					foreach ( $value as $col => $val ) {
						$where .= sprintf( ' %s %s = %s', $args['where']['relation'], $col, $val );
					}

				} elseif ( $column == 'fields_date' ) {
					$where .= $value;
				}
			}
		}

		$query = "SELECT {$args['fields']} FROM {$table} WHERE 1 = 1{$where}";

		if ( $args['group'] ) {
			$query .= sprintf( ' GROUP BY %s', $args['group'] );
		}

		if ( $args['order'] ) {
			$query .= sprintf( ' ORDER BY %s', $args['order'] );
		}

		if ( $args['limit'] ) {
			$query .= sprintf( ' LIMIT %d', $args['limit'] );
		}

		if ( $args['offset'] ) {
			$query .= sprintf( ' OFFSET %d', $args['offset'] );
		}

		if ( $args['return'] == 'query' ) {
			return $query;
		}

		return $wpdb->{'get_' . $args['return']}( $query );
	}
}

// Site changes
if ( ! function_exists( 'wpj_check_site_changes' ) ) {
	function wpj_check_site_changes( $uid = 0 ) {
		$uid = isset( $_POST['uid'] ) ? $_POST['uid'] : $uid;

		if ( ! $uid ) {
			$uid = get_current_user_id();
		}

		$options = get_option( 'jobster_settings' );
		$enabled = $options['wpjobster_enable_live_notifications'];

		$notifications = get_user_meta( $uid, 'notifications_number', true );
		$messages      = get_user_meta( $uid, 'messages_number', true );

		$notification_info = get_user_meta( $uid, 'notification_info', true );

		$response = [
			'enabled'           => $enabled,
			'notifications'     => $notifications,
			'messages'          => $messages,
			'current_time'      => time(),
			'timeout'           => 2000,
			'max_timeout'       => 32000,
			'notification_info' => json_encode( $notification_info )
		];

		// update user last visit
		update_user_meta( $uid, 'last_user_login', current_time( 'timestamp', 1 ) );

		// update user last IP
		if ( ! empty( $_SERVER['HTTP_CLIENT_IP'] ) ) $ip = $_SERVER['HTTP_CLIENT_IP'];
		elseif ( ! empty( $_SERVER['HTTP_X_FORWARDED_FOR'] ) ) $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
		else $ip = $_SERVER['REMOTE_ADDR'];

		update_user_meta( $uid, 'ip_reg', $ip );

		wp_send_json( $response );
		wp_die();
	}
}

require get_template_directory() . '/models/init.php';
require get_template_directory() . '/vendor/init.php';
require get_template_directory() . '/includes/init.php';
require get_template_directory() . '/lib/init.php';
require get_template_directory() . '/admin/init.php';