<?php class WPJ_Badge {

	private $payment_gateway;

	public function __construct( $payment_gateway = '' ) {
		if ( ! $payment_gateway ) $this->payment_gateway = WPJ_Form::get( 'pay_for_item' );
		else $this->payment_gateway = $payment_gateway;

		add_action( 'wpjobster_badge_payment_success', [$this, 'process'], 10, 5 );
		add_action( 'wpjobster_badge_payment_failed',  [$this, 'failed'],  10, 5 );
		add_action( 'wpjobster_badge_payment_other',   [$this, 'other'],   10, 6 );
	}

	public function insert( $payment_gateway = '' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get current order ID
		if ( ! empty( $_GET['oid'] ) && isset( $_GET['process_pending'] ) ) $oid = $_GET['oid'];
		else $oid = 0;

		// Insert order if is new
		if ( $oid == 0 ) $oid = wpj_insert_badge_purchase_order(['payment_gateway' => $payment_gateway]);

		// Get the new order data
		$order = wpj_get_badge_order( '*', ['id' => $oid], 'row' );

		// Action
		do_action( 'wpj_after_new_badge_order', $order );

		// Return
		return $order;
	}

	public function process( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get badge order
		$badge_order = wpj_get_badge_order( '*', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Start the payment process
		if ( isset( $badge_order->payment_status ) && $badge_order->payment_status != 'completed' ) {
			$update = true;

			// Assign badge to user
			if ( ! is_demo_user() ) {
				$current_badges = get_user_meta( $badge_order->user_id, 'user_badge', true );

				if ( $current_badges ) {
					array_push( $current_badges, $badge_order->badge_nr );

					$badges = array_unique( $current_badges );

				} else {
					$badges = [$badge_order->badge_nr];

				}

				$user_credits = wpj_get_user_credit( $badge_order->user_id );

				if ( $badges && $badge_order->payment_gateway == 'credits' && $badge_order->price <= $user_credits ) {
					wpj_update_user_credit( $badge_order->user_id, ( $user_credits - $badge_order->price ) );

				} elseif ( $badge_order->payment_gateway == 'credits' && $badge_order->price > $user_credits ) {
					$update = false;

				}

			} else {
				$update = false;

			}

			if ( $update ) {
				// Add badge to user
				if ( ! empty( $badges ) ) {
					update_user_meta( $badge_order->user_id, 'user_badge', $badges );
				}

				// Save log
				wpj_add_history_log([
					'tp'        => '0',
					'reason'    => sprintf( __( 'Badge: %s', 'wpjobster' ), $badge_order->description ),
					'amount'    => $badge_order->price,
					'uid'       => $badge_order->user_id,
					'oid'       => $oid,
					'rid'       => 26,
					'details'   => $badge_order->description,
					'payed_amt' => $badge_order->payment_currency . '|' . $badge_order->price
				]);

				// Send emails
				$email_data = [
					'##username##'        => wpj_get_user_display_type( $badge_order->user_id ),
					'##payment_gateway##' => $badge_order->payment_gateway,
					'##badge_title##'     => $badge_order->description,
					'##badge_price##'     => wpj_show_price( $badge_order->price )
				];

				wpj_notify_user_translated( 'badge_new', $badge_order->user_id, $email_data );
				wpj_notify_user_translated( 'badge_admin_new', 'admin', $email_data );

				// Update payment
				wpj_update_payment(
					['payment_status' => 'completed', 'payment_details' => $details, 'payment_response' => $response],
					['payment_type_id' => $oid, 'payment_type' => 'badge']
				);

				// Update order
				wpj_update_badge_order(
					['payment_status' => 'completed', 'payment_response' => $response],
					['id' => $oid]
				);

				// Action
				do_action( 'wpj_badge_payment_completed', $oid );
			}
		}

		// Redirect
		$this->redirect( $redirect );
	}

	public function failed( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => 'cancelled', 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'badge']
		);

		// Update order
		wpj_update_badge_order(
			['payment_status' => 'cancelled', 'payment_response' => $response],
			['id' => $oid]
		);

		// Action
		do_action( 'wpj_after_order_is_cancelled', $oid, 'badge' );

		// Redirect
		$this->redirect( $redirect );
	}

	public function other( $oid, $payment_gateway = '', $details = '', $response = '', $status = 'processing', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => $status, 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'badge']
		);

		// Update order
		wpj_update_badge_order(
			['payment_status' => $status, 'payment_response' => $response],
			['id' => $oid]
		);

		// Action
		do_action( 'wpjobster_badge_payment_other', $oid );

		// Redirect
		$this->redirect( $redirect );
	}

	private function redirect( $redirect = 'yes' ) {
		if ( $redirect == 'yes' ) {
			if ( isset( $_SERVER['HTTP_REFERER'] ) && strpos( $_SERVER['HTTP_REFERER'], 'page=jobster-orders' ) && strpos( $_SERVER['HTTP_REFERER'], 'admin.php' ) )
				wp_redirect( wpj_get_admin_order_link( 'badge' ) );
			else
				wp_redirect( wpj_get_order_link_by_payment_type( 'badge' ) );

			exit;
		}
	}

}