<?php class WPJ_Feature {

	private $payment_gateway;

	public function __construct( $payment_gateway = '' ) {
		if ( ! $payment_gateway ) $this->payment_gateway = WPJ_Form::get( 'pay_for_item' );
		else $this->payment_gateway = $payment_gateway;

		add_action( 'wpjobster_feature_payment_success', [$this, 'process'], 10, 5 );
		add_action( 'wpjobster_feature_payment_failed',  [$this, 'failed'],  10, 5 );
		add_action( 'wpjobster_feature_payment_other',   [$this, 'other'],   10, 6 );
	}

	public function insert( $payment_gateway = '' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get current order ID
		if ( ! empty( $_GET['oid'] ) && isset( $_GET['process_pending'] ) ) $oid = $_GET['oid'];
		else $oid = 0;

		// Insert order if is new
		if ( $oid == 0 ) $oid = wpj_insert_feature_purchase_order(['payment_gateway' => $payment_gateway]);

		// Get the new order data
		$order = wpj_get_feature_order( '*', ['id' => $oid], 'row' );

		// Action
		do_action( 'wpj_after_new_feature_order', $order );

		// Return
		return $order;
	}

	public function process( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get feature order
		$featured_order = wpj_get_feature_order( '*', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Start the payment process
		if ( isset( $featured_order->payment_status ) && $featured_order->payment_status != 'completed' ) {
			// Mark job as featured on homepage
			if ( strpos( $featured_order->feature_pages, 'h' ) !== false )
				wpj_mark_job_as_featured( 'homepage', $featured_order->job_id );

			// Mark job as featured on category
			if ( strpos( $featured_order->feature_pages, 'c' ) !== false )
				wpj_mark_job_as_featured( 'category', $featured_order->job_id );

			// Mark job as featured on subcategory
			if ( strpos( $featured_order->feature_pages, 's') !== false )
				wpj_mark_job_as_featured( 'subcategory', $featured_order->job_id );

			// Save log
			wpj_add_history_log([
				'tp'        => '0',
				'reason'    => __( 'Feature job', 'wpjobster' ) . ': <a href="' . get_permalink( $featured_order->job_id ) . '">' . get_the_title( $featured_order->job_id ) . '</a>',
				'amount'    => $featured_order->featured_amount,
				'uid'       => $featured_order->user_id,
				'oid'       => $oid,
				'rid'       => 10,
				'details'   => $featured_order->job_id,
				'payed_amt' => $featured_order->currency . '|' . $featured_order->featured_amount
			]);

			// Send emails
			$email_data = [
				'##username##'          => wpj_get_user_display_type( $featured_order->user_id ),
				'##job_link##'          => urldecode( get_permalink( $featured_order->job_id ) ),
				'##job_name##'          => get_the_title( $featured_order->job_id ),
				'##all_featured_info##' => wpj_get_feature_info_for_email( $featured_order->job_id )
			];

			wpj_notify_user_translated( 'featured_new', $featured_order->user_id, $email_data );

			wpj_notify_user_translated( 'featured_admin_new', 'admin', $email_data );

			// Update payment
			wpj_update_payment(
				['payment_status' => 'completed', 'payment_details' => $details, 'payment_response' => $response],
				['payment_type_id' => $oid, 'payment_type' => 'feature']
			);

			// Update order
			wpj_update_feature_order(
				['payment_status' => 'completed', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
				['id' => $oid]
			);

			// Action
			do_action( 'wpj_feature_payment_completed', $oid );

		}

		// Redirect
		$this->redirect( $redirect, $oid, 'success' );
	}

	public function failed( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => 'cancelled', 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'feature']
		);

		// Update order
		wpj_update_feature_order(
			['payment_status' => 'cancelled', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
			['id' => $oid]
		);

		// Actions
		do_action( 'wpj_after_order_is_cancelled', $oid, 'feature' );
		do_action( 'wpj_feature_payment_failed', $oid );

		// Redirect
		$this->redirect( $redirect, $oid, 'fail' );
	}

	public function other( $oid, $payment_gateway = '', $details = '', $response = '', $status = 'processing', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => $status, 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'feature']
		);

		// Update order
		wpj_update_feature_order(
			['payment_status' => $status, 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
			['id' => $oid]
		);

		// Action
		do_action( 'wpjobster_feature_payment_other', $oid );

		// Redirect
		$this->redirect( $redirect, $oid, 'success' );
	}

	private function redirect( $redirect = 'yes', $oid = 0, $status = 'success' ) {
		if ( $redirect == 'yes' ) {
			if ( isset( $_SERVER['HTTP_REFERER'] ) && strpos( $_SERVER['HTTP_REFERER'], 'page=jobster-orders' ) && strpos( $_SERVER['HTTP_REFERER'], 'admin.php' ) )
				wp_redirect( wpj_get_admin_order_link( 'feature' ) );
			else
				wp_redirect( wpj_get_order_link_by_payment_type( 'feature', $oid, $status ) );

			exit;
		}
	}

}