<?php class WPJ_Subscription {

	private $payment_gateway;

	public function __construct( $payment_gateway = '' ) {
		if ( ! $payment_gateway ) $this->payment_gateway = WPJ_Form::get( 'pay_for_item' );
		else $this->payment_gateway = $payment_gateway;

		add_action( 'wpjobster_subscription_payment_success', [$this, 'process'], 10, 5 );
		add_action( 'wpjobster_subscription_payment_failed',  [$this, 'failed'],  10, 5 );
		add_action( 'wpjobster_subscription_payment_other',   [$this, 'other'],   10, 6 );
	}

	public function insert( $payment_gateway = '' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get current order ID
		if ( ! empty( $_GET['oid'] ) && isset( $_GET['process_pending'] ) ) $oid = $_GET['oid'];
		else $oid = 0;

		// Insert order if is new
		if ( $oid == 0 ) $oid = wpj_insert_subscription_purchase_order(['payment_gateway' => $payment_gateway]);

		// Get the new order data
		$order = wpj_get_subscription_order( '*', ['id' => $oid], 'row' );

		// Action
		do_action( 'wpj_after_new_subscription_order', $order );

		// Return
		return $order;
	}

	public function process( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get subscription order
		$subscription_order = wpj_get_subscription_order( 'payment_status, user_id', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Start the payment process
		if ( isset( $subscription_order->payment_status ) && $subscription_order->payment_status != 'completed' ) {
			// Activate subscription
			wpj_activate_subscription_order( $oid );

			// Update payment
			wpj_update_payment(
				['payment_status' => 'completed', 'payment_details' => $details, 'payment_response' => $response],
				['payment_type_id' => $oid, 'payment_type' => 'subscription']
			);

			// Update order
			wpj_update_subscription_order(
				['payment_status' => 'completed', 'subscription_status' => 'active', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response, 'profile_id' => $subscription_order->user_id],
				['id' => $oid]
			);

			// Action
			do_action( 'wpjobster_subscription_payment_completed', $oid );

		}

		// Redirect
		$this->redirect( $redirect, 'thankyou', 'success' );

	}

	public function failed( $oid, $payment_gateway = '', $details = 'Subscription cancelled', $response = '', $redirect = 'yes' ) {
		// Get subscription order
		$subscription_order = wpj_get_subscription_order( '*', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Send emails
		$email_data = [
			'##username##'                    => wpj_get_user_display_type( $subscription_order->user_id ),
			'##amount_updated##'              => $subscription_order->amount,
			'##current_subscription_level##'  => wpj_translate_string( $subscription_order->level ),
			'##current_subscription_period##' => wpj_translate_string( $subscription_order->plan ),
			'##current_subscription_amount##' => $subscription_order->amount
		];

		wpj_notify_user_translated( 'subscription_cancel', $subscription_order->user_id, $email_data );

		wpj_notify_user_translated( 'admin_cancel_subscription', 'admin', $email_data );

		// Update payment
		wpj_update_payment(
			['payment_status' => 'cancelled', 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $subscription_order->id, 'payment_type' => 'subscription']
		);

		// Update order
		wpj_update_subscription_order(
			['payment_status' => 'cancelled', 'subscription_status' => 'inactive', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response, 'profile_id' => $subscription_order->user_id],
			['id' => $subscription_order->id]
		);

		// Action
		do_action( 'wpj_after_order_is_cancelled', $subscription_order->id, 'subscription' );
		do_action( 'wpj_subscription_payment_failed', $subscription_order->id );

		// Checks
		wpj_do_user_level_extras_check( $subscription_order->user_id );
		wpj_do_user_level_extras_price_check( $subscription_order->user_id );
		wpj_do_user_level_job_price_check( $subscription_order->user_id );

		// Redirect
		$this->redirect( $redirect, 'sub_error', 'cancelled' );
	}

	public function other( $oid, $payment_gateway = '', $details = 'Subscription processing', $response = '', $status = 'processing', $redirect = 'yes' ) {
		// Get subscription order
		$subscription_order = wpj_get_subscription_order( 'user_id', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => $status, 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'subscription']
		);

		// Update order
		wpj_update_subscription_order(
			['payment_status' => $status, 'subscription_status' => 'inactive', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response, 'profile_id' => $subscription_order->user_id],
			['id' => $oid]
		);

		// Action
		do_action( 'wpj_subscription_payment_other', $oid );

		// Redirect
		$this->redirect( $redirect, 'thankyou', 'success' );
	}

	private function redirect( $redirect = 'yes', $value = 'thankyou', $status = 'success' ) {
		if ( $redirect == 'yes' ) {
			if ( isset( $_SERVER['HTTP_REFERER'] ) && strpos( $_SERVER['HTTP_REFERER'], 'page=jobster-orders' ) && strpos( $_SERVER['HTTP_REFERER'], 'admin.php' ) )
				wp_redirect( wpj_get_admin_order_link( 'subscription' ) );
			else
				wp_redirect( wpj_get_order_link_by_payment_type( 'subscription', '', $value, $status ) );

			exit;
		}
	}

}