<?php class WPJ_Topup {

	private $payment_gateway;

	public function __construct( $payment_gateway = '' ) {
		if ( ! $payment_gateway ) $this->payment_gateway = WPJ_Form::get( 'pay_for_item' );
		else $this->payment_gateway = $payment_gateway;

		add_action( 'wpjobster_topup_payment_success', [$this, 'process'], 10, 5 );
		add_action( 'wpjobster_topup_payment_failed',  [$this, 'failed'],  10, 5 );
		add_action( 'wpjobster_topup_payment_other',   [$this, 'other'],   10, 6 );
	}

	public function insert( $payment_gateway = '' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get current order ID
		if ( ! empty( $_GET['oid'] ) && isset( $_GET['process_pending'] ) ) $oid = $_GET['oid'];
		else $oid = 0;

		// Insert order if is new
		if ( $oid == 0 ) $oid = wpj_insert_topup_purchase_order(['payment_gateway' => $payment_gateway]);

		// Get the new order
		$order = wpj_get_topup_order( '*', ['id' => $oid], 'row' );

		// Action
		do_action( 'wpj_after_new_topup_order', $order );

		// Return
		return $order;
	}

	public function process( $oid, $payment_gateway = '', $details = '', $response = '', $redirect = 'yes' ) {
		// Get topup order
		$topup_order = wpj_get_topup_order( '*', ['id' => $oid], 'row' );

		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Start the payment process
		if ( isset( $topup_order->payment_status ) && $topup_order->payment_status != 'completed' ) {
			// Increase credits
			$final_price = wpj_get_topup_amount_by_package( $topup_order->package_id, 'credit' );

			if ( $topup_order->currency != wpj_get_site_currency() ) {
				$final_price = wpj_get_exchanged_value( $final_price, wpj_get_site_default_currency(), wpj_get_site_currency() );
			}

			wpj_update_user_credit( $topup_order->user_id, wpj_get_user_credit( $topup_order->user_id ) + $final_price );

			// Activate jobs with 'no_credits' deactivation reason
			$posts = wpj_get_deactivated_jobs_by_reason( wpj_get_buyer_by_payment_type( $oid, 'topup' ), 'no_credits' );

			if ( $posts ) {
				foreach ( $posts as $post ) {
					wpj_activate_job( $post->ID );
				}
			}

			// Save log
			wpj_add_history_log([
				'tp'        => '1',
				'reason'    => __( 'Top Up account balance', 'wpjobster' ),
				'amount'    => $topup_order->package_amount,
				'uid'       => $topup_order->user_id,
				'oid'       => $oid,
				'rid'       => 12,
				'details'   => $details,
				'payed_amt' => $topup_order->currency . '|' . $topup_order->package_amount
			]);

			// Send emails
			$email_data = [
				'##amount_updated##'             => $final_price,
				'##username##'                   => wpj_get_user_display_type( $topup_order->user_id ),
				'##amount_updated_in_currency##' => $topup_order->package_amount . ' ' . $topup_order->currency,
				'##payment_gateway##'            => $topup_order->payment_gateway_name
			];

			if ( $topup_order->payment_gateway_name == 'paypal' ) {
				wpj_notify_user_translated( 'balance_up_paypal', $topup_order->user_id, $email_data );
				wpj_notify_user_translated( 'balance_admin_up_paypal', 'admin', $email_data );

			} else {
				wpj_notify_user_translated( 'balance_up_topup', $topup_order->user_id, $email_data );
				wpj_notify_user_translated( 'balance_admin_up_topup', 'admin', $email_data );

			}

			// Update payment
			wpj_update_payment(
				['payment_status' => 'completed', 'payment_details' => $details, 'payment_response' => $response],
				['payment_type_id' => $oid, 'payment_type' => 'topup']
			);

			// Update order
			wpj_update_topup_order(
				['payment_status' => 'completed', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
				['id' => $oid]
			);

			// Action
			do_action( 'wpj_topup_payment_completed', $oid );
		}

		// Redirect
		$this->redirect( $redirect, $oid );
	}

	public function failed( $oid, $payment_gateway = '', $details = '',$response = '', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => 'cancelled', 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'topup']
		);

		// Update order
		wpj_update_topup_order(
			['payment_status' => 'cancelled', 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
			['id' => $oid]
		);

		// Actions
		do_action( 'wpj_after_order_is_cancelled', $oid, 'topup' );
		do_action( 'wpj_topup_payment_failed', $oid );

		// Redirect
		$this->redirect( $redirect, $oid );
	}

	public function other( $oid, $payment_gateway = '', $details = '', $response = '', $status = 'processing', $redirect = 'yes' ) {
		// Get payment gateway
		if ( ! $payment_gateway ) $payment_gateway = $this->payment_gateway;

		// Get details
		if ( ! $details ) $details = $payment_gateway;

		// Update payment
		wpj_update_payment(
			['payment_status' => $status, 'payment_details' => $details, 'payment_response' => $response],
			['payment_type_id' => $oid, 'payment_type' => 'topup']
		);

		// Update order
		wpj_update_topup_order(
			['payment_status' => $status, 'payment_gateway_transaction_id' => $details, 'payment_response' => $response],
			['id' => $oid]
		);

		// Action
		do_action( 'wpjobster_topup_payment_other', $oid );

		// Redirect
		$this->redirect( $redirect, $oid );
	}

	private function redirect( $redirect = 'yes', $oid = 0 ) {
		if ( $redirect == 'yes' ) {
			if ( isset( $_SERVER['HTTP_REFERER'] ) && strpos( $_SERVER['HTTP_REFERER'], 'page=jobster-orders' ) && strpos( $_SERVER['HTTP_REFERER'], 'admin.php' ) )
				wp_redirect( wpj_get_admin_order_link( 'topup' ) );
			else
				wp_redirect( wpj_get_order_link_by_payment_type( 'topup', $oid ) );

			exit;
		}
	}

}