<?php
add_action( 'template_redirect', 'wpj_payment_init_redirect', 1 );
if ( ! function_exists( 'wpj_payment_init_redirect' ) ) {
	function wpj_payment_init_redirect() {

		if ( ! empty( $_GET['pay_for_item'] ) || ! empty( $_GET['payment_response'] ) ) {

			// Set the current action by url args
			if ( ! empty( $_GET['pay_for_item'] ) ) {
				$action     = 'do_payment';
				$action_key = 'action';

				$gateway_name = $_GET['pay_for_item'];
				$payment_type = WPJ_Form::get( 'payment_type', 'job_purchase' );

			} elseif ( ! empty( $_GET['payment_response'] ) ) {
				$action     = 'process_payment';
				$action_key = 'response_action';

				$payment = isset( $_REQUEST['payment_id'] ) ? wpj_get_payment( ['id' => $_REQUEST['payment_id']] ) : '';

				$gateway_name = $_GET['payment_response'];
				$payment_type = ! empty( $payment->payment_type ) ? $payment->payment_type : '';
			}

			// Init and process the payment
			if ( ! empty( $payment_type ) ) {
				$payment_type_arr = ['feature', 'custom_extra', 'subscription', 'topup', 'job_purchase', 'tips', 'badge'];

				foreach ( $payment_type_arr as $pt ) {

					if ( $payment_type == $pt ) {

						foreach ( wpj_get_payment_gateways() as $gateway ) {
							if ( $gateway_name == $gateway['unique_id'] && isset( $gateway['action'] ) )
								$payment_method_name = $gateway[$action_key];
						}

						if ( ! empty( $payment_method_name ) || ( isset( $_GET['pay_for_item'] ) && ( $_GET['pay_for_item'] == 'credits' || $_GET['pay_for_item'] == 'cod' ) ) ) {

							// Include payment type class
							$class_name = 'WPJ_' . str_replace( '_', '_', ucwords( $pt, '_' ) );
							if ( ! class_exists( $class_name ) ) {
								include_once get_template_directory() . '/lib/gateways/class-' . str_replace( '_', '-', $pt ) . '.php';
								$payment_type_class = new $class_name( $gateway_name );
							}

							// Include gateway class
							if ( $gateway_name != 'credits' && $gateway_name != 'cod' && $gateway_name != 'banktransfer' && $gateway_name != 'paypal' ) {
								if ( ! class_exists( 'WPJobster_' . $gateway_name . '_Loader' ) && file_exists( WP_PLUGIN_DIR . '/wpjobster-{$gateway_name}/wpjobster-{$gateway_name}.php' ) ) {
									include WP_PLUGIN_DIR . '/wpjobster-{$gateway_name}/wpjobster-{$gateway_name}.php';
								}

							} elseif ( $gateway_name == 'paypal' && class_exists( 'WPJobster_PayPal_Loader' ) ) {
								$gateway_class = new WPJobster_PayPal_Loader( 'paypal' );

							} elseif ( $gateway_name == 'banktransfer' ) {
								include_once get_template_directory() . '/admin/jobster-orders/class-orders.php';
								$order_class = new WPJ_Orders();

							}

							// Make the payment
							if ( $action == 'do_payment' ) {

								// Validates the payment before sending it
								wpj_display_order_errors( $pt );

								// Insert order to database
								$insert_order = $payment_type_class->insert( $gateway_name );

								// Get order from database
								$order = wpj_json_decode( json_encode( $insert_order ), true );

								if ( $gateway_name == 'credits' || $gateway_name == 'cod' ) {

									// Mark the payment completed if Credits or COD
									do_action( 'wpjobster_' . $pt . '_payment_success', $order['id'], $gateway_name, '', json_encode( $order ), 'yes' );

								} else {

									// Go to 'initializePayment' plugin class method
									do_action( $payment_method_name, $pt, $order );

								}

								exit;
							}

							// Process the payment
							if ( $action == 'process_payment' ) {

								// Go to 'processPayment' plugin class method
								do_action( $payment_method_name, $pt, $payment_type_class );

								// Go to order page if any error appears
								wp_redirect( wpj_get_order_link_by_payment_type( $payment->payment_type, $payment->payment_type_id ) ); exit;

							}

						}

					}

				}

			} elseif ( $action == 'process_payment' ) { // Process the IPN payment

				// Go to 'processPayment' plugin class method
				do_action( 'wpjobster_processafter_' . $gateway_name . '_gateway', 'ipn', 'ipn' );

			}

			// If payment type is not set, redirect to homepage
			wp_redirect( get_bloginfo( 'url' ) ); exit;
		}

		// Process withdrawal response
		if ( ! empty( $_GET['payout_response'] ) ) {
			include_once get_template_directory() . '/lib/plugins/wpjobster-paypal/lib/paypal-withdrawal/vendor/paypal/rest-api-sdk-php/wpj/payment.php';
		}

	}
}