<?php // PayPal Settings

Redux::setSection( $opt_name, array(
	'title'      => __( 'PayPal', 'wpjobster' ),
	'desc'       => __( 'PayPal Settings', 'wpjobster' ),
	'id'         => 'paypal-settings',
	'subsection' => true,
	'fields'     => array_merge(

/* PURCHASE */

		wpj_get_gateway_default_fields(
			array(
				'gateway_id'      => 'paypal',
				'gateway_name'    => 'PayPal',
				'gateway_version' => '1.0',
				'license'         => false,
				'public_key'      => false,
				'secret_key'      => false,
				'new_fields'      => array(
					array(
						'unique_id' => 'paypal-settings-section',
						'type'      => 'section',
						'title'     => esc_html__( 'Gateway Settings', 'wpjobster' ),
						'indent'    => true,
					),
					array(
						'unique_id' => 'wpjobster_paypal_enable_secure',
						'type'      => 'switch',
						'title'     => __( 'Certificate installed on the server', 'wpjobster' ),
						'subtitle'  => __( 'Set it to yes only if you know what it means and you have the SSL API certificates from PayPal on your server.', 'wpjobster' ),
						'default'   => false
					),
					array(
						'unique_id' => 'wpjobster_paypal_email',
						'type'      => 'text',
						'title'     => __( 'PayPal email address', 'wpjobster' ),
						'subtitle'  => __( 'Enter the email address of your Paypal account, the account in which you will receive your customers\' money', 'wpjobster' )
					)
				)
			)
		),

		array(

/* WITHDRAWAL */
			array(
				'id'       => 'paypal-withdrawal-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Withdrawal', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_paypal_enable_withdraw', '=', true ),
			),
			array(
				'id'       => 'wpjobster_theme_appid',
				'type'     => 'text',
				'title'    => __( 'PayPal client ID', 'wpjobster' )
			),
			array(
				'id'       => 'wpjobster_theme_appsecret',
				'type'     => 'text',
				'title'    => __( 'PayPal secret', 'wpjobster' ),
			),
			array(
				'id'       => 'paypal-withdrawal-info-link',
				'type'     => 'switch',
				'title'    => __( 'Show info', 'wpjobster' ),
				'default'  => false,
			),
			array(
				'id'       => 'paypal-info-1',
				'type'     => 'info',
				'title'    => __( 'To get your withdrawal credentials, follow these steps:', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-2',
				'type'     => 'info',
				'title'    => __( '1. Login to your paypal account', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-3',
				'type'     => 'info',
				'title'    => sprintf( __( '2. Go to %s', 'wpjobster' ), '<a target="_blank" href="https://developer.paypal.com/developer/applications">https://developer.paypal.com/developer/applications</a>' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-4',
				'type'     => 'info',
				'title'    => __( '3. Select Live or Sandbox', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-5',
				'type'     => 'info',
				'title'    => __( '4. Click "Create app"', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-6',
				'type'     => 'info',
				'title'    => '',
				'desc'     => '<img src="' . get_template_directory_uri() . '/assets/images/admin/create_paypal_app_button.webp" width="900" height="487" />',
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-7',
				'type'     => 'info',
				'title'    => __( '5. Fill the "App Name" input', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-8',
				'type'     => 'info',
				'title'    => __( '6. Select an account', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-9',
				'type'     => 'info',
				'title'    => __( '7. Click "Create app"', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-10',
				'type'     => 'info',
				'title'    => '',
				'desc'     => '<img src="' . get_template_directory_uri() . '/assets/images/admin/create_paypal_app_details.webp" width="900" height="605" />',
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-11',
				'type'     => 'info',
				'title'    => __( '8. Click "Show" secret field and copy your credentials to the above fields', 'wpjobster' ),
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-12',
				'type'     => 'info',
				'title'    => '',
				'desc'     => '<img src="' . get_template_directory_uri() . '/assets/images/admin/view_paypal_withdrawal_credentials.webp" width="900" height="485" />',
				'required' => array( 'paypal-withdrawal-info-link', '=', true )
			),

/* SUBSCRIPTION */
			array(
				'id'       => 'paypal-subscription-settings',
				'type'     => 'section',
				'title'    => esc_html__( 'Subscription', 'wpjobster' ),
				'indent'   => true,
				'required' => array( 'wpjobster_paypal_enable_subscription', '=', true ),
			),
			array(
				'id'       => 'wpjobster_theme_apiusername',
				'type'     => 'text',
				'title'    => __( 'Paypal API username', 'wpjobster' )
			),
			array(
				'id'       => 'wpjobster_theme_apipassword',
				'type'     => 'text',
				'title'    => __( 'Paypal API password', 'wpjobster' )
			),
			array(
				'id'       => 'wpjobster_theme_apisignature',
				'type'     => 'text',
				'title'    => __( 'Paypal API signature', 'wpjobster' )
			),
			array(
				'id'       => 'paypal-subscription-info-link',
				'type'     => 'switch',
				'title'    => __( 'Show info', 'wpjobster' ),
				'default'  => false,
			),
			array(
				'id'       => 'paypal-info-13',
				'type'     => 'info',
				'title'    => __( 'To get your subscription credentials, follow these steps:', 'wpjobster' ),
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-14',
				'type'     => 'info',
				'title'    => __( '1. Login to your paypal account', 'wpjobster' ),
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-15',
				'type'     => 'info',
				'title'    => sprintf( __( '2. Go to %s', 'wpjobster' ), '<a target="_blank" href="https://developer.paypal.com/developer/accounts">https://developer.paypal.com/developer/accounts</a>' ),
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-16',
				'type'     => 'info',
				'title'    => __( '3. Testing Tools > Sandbox accounts > Select the account > Click on three dots button > Click View/edit account', 'wpjobster' ),
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-17',
				'type'     => 'info',
				'title'    => '',
				'desc'     => '<img src="' . get_template_directory_uri() . '/assets/images/admin/paypal_subscription_api_credentials_1.png" width="900" height="383" />',
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-18',
				'type'     => 'info',
				'title'    => __( '4. Click "API Credentials" tab', 'wpjobster' ),
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
			array(
				'id'       => 'paypal-info-19',
				'type'     => 'info',
				'title'    => '',
				'desc'     => '<img src="' . get_template_directory_uri() . '/assets/images/admin/paypal_subscription_api_credentials_2.png" width="900" height="360" />',
				'required' => array( 'paypal-subscription-info-link', '=', true )
			),
		)
	)
) );

do_action( 'wpj_after_admin_paypal_settings_fields' );