<?php
$composerAutoload = dirname( dirname( dirname( __DIR__ ) ) ) . '/autoload.php';

if ( ! file_exists( $composerAutoload ) ) {
	$composerAutoload = dirname(__DIR__) . '/vendor/autoload.php';

	if ( ! file_exists( $composerAutoload ) ) {
		echo "The 'vendor' folder is missing. You must run 'composer update' to resolve application dependencies.\nPlease see the README for more information.\n";
		exit( 1 );
	}
}

require $composerAutoload;

use PayPal\Auth\OAuthTokenCredential;
use PayPal\Rest\ApiContext;

$clientId     = wpj_get_option( 'wpjobster_theme_appid' );
$clientSecret = wpj_get_option( 'wpjobster_theme_appsecret' );

$mode = wpj_get_option( 'wpjobster_paypal_enable_sandbox' ) == 'yes' ? 'sandbox' : 'live';

$apiContext = getApiContext( $clientId, $clientSecret, $mode );

return $apiContext;

/**
 * Helper method for getting an APIContext for all calls
 * @param string $clientId Client ID
 * @param string $clientSecret Client Secret
 * @return PayPal\Rest\ApiContext
 */
function getApiContext( $clientId, $clientSecret, $mode = 'sandbox' ) {

	$apiContext = new ApiContext(
		new OAuthTokenCredential(
			$clientId,
			$clientSecret
		)
	);

	$apiContext->setConfig(
		array(
			'mode'           => $mode,
			'log.LogEnabled' => true,
			'log.FileName'   => '../PayPal.log',
			'log.LogLevel'   => 'DEBUG',
			'cache.enabled'  => true
		)
	);

	return $apiContext;
}