<?php /*** ADMIN COLUMNS ***/

class WPJREPORT_AdminColumns {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_filter( 'manage_edit-reports_columns', array( $this, 'columnHead' ), 10, 1 );
		add_action( 'manage_reports_posts_custom_column', array( $this, 'columnContent' ), 10, 2 );

		add_filter( 'wpj_admin_pending_posts_filter', function( $post_types ) { array_push( $post_types, 'reports' ); return $post_types; }, 10, 1 );
	}

	public function columnHead( $columns ) {
		$columns = array(
			"cb"     => "<input type=\"checkbox\" />",
			"title"  => __( "Title", 'wpjobster' ),
			"author" => __( "Reported By", 'wpjobster' ),
			"user"   => __( "Reported User", 'wpjobster' ),
			"reason" => __( "Reason", 'wpjobster' ),
			"target" => __( "Target", 'wpjobster' ),
			"date"   => __( "Date", 'wpjobster' ),
			"go_to"  => __( "Go to", 'wpjobster' )
		);

		return $columns;
	}

	public function columnContent( $column, $post_id  ) {
		switch ( $column ) {

			case 'user'   :
				echo '<a href="' . urldecode( get_edit_user_link( get_post_meta( $post_id, 'reported_author', true ) ) ) . '">' . __( 'View reported user', 'wpjobster' ) . '</a>';
				break;

			case 'reason' :
				echo strip_tags( get_the_term_list( $post_id , 'reason_reports' ) );
				break;

			case 'target' :
				echo strip_tags( get_the_term_list( $post_id , 'target_reports' ) );
				break;

			case 'go_to' :
				if ( strip_tags( get_the_term_list( $post_id , 'target_reports' ) ) == 'Jobs' ) {
					echo '<a href="' . urldecode( get_edit_post_link( get_post_meta( $post_id, 'reported_id', true ) ) ) . '">' . __( 'View reported job', 'wpjobster' ) . '</a>';

				} elseif ( strip_tags( get_the_term_list( $post_id , 'target_reports' ) ) == 'Requests' ) {
					echo '<a href="' . urldecode( get_edit_post_link( get_post_meta( $post_id, 'reported_id', true ) ) ) . '">' . __( 'View reported request', 'wpjobster' ) . '</a>';

				} elseif ( strip_tags( get_the_term_list( $post_id , 'target_reports' ) ) == 'Users' ) {
					echo '<a href="' . urldecode( get_edit_user_link( get_post_meta( $post_id, 'reported_id', true ) ) ) . '">' . __( 'View reported user', 'wpjobster' ) . '</a>';

				} elseif ( strip_tags( get_the_term_list( $post_id , 'target_reports' ) ) == 'Messages' ) {
					echo '<a href="' . get_admin_url() . 'admin.php?page=jobster-messages&active_tab=private-messages&search_user=' . get_post_meta( $post_id, 'reported_author', true ) . '">' . __( 'View reported message', 'wpjobster' ) . '</a>';

				}
				break;

		}
	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_AdminColumns', 'init' ) );
