<?php /*** ADMIN EMAILS ***/

class WPJREPORT_AdminEmails {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {

		/* Email template for admin */
		add_filter( 'wpjobster_admin_menu_email_templates', array( $this, 'email_templates_filter' ), 10, 1 );

		/* Email template content for admin */
		add_action( 'admin_init', array( $this, 'demo_content' ) );

	}

	function email_templates_filter( $reasons ) {

		$reasons['reports'] = array(
			"title" => "Reports",
			"items" => array(
				"report_jobs" => array(
					"title"       => __( "Report job", "wpjobster" ),
					"description" =>
						"This notification will be received by the user when he reports a job.
						<br /><br /> Available shortcodes:
						<br /><br /> <strong>##receiver_id##, <br /> ##receiver_username##, <br /> ##reported_author_id##, <br /> ##reported_author_username##, <br /> ##reported_id##, <br /> ##reported_title##, <br /> ##reported_public_link##, <br /> ##report_description##, <br /> ##report_target##, <br /> ##your_site_name##, <br /> ##your_site_url##</strong>"
				),
				"report_requests" => array(
					"title"       => __( "Report request", "wpjobster" ),
					"description" =>
						"This notification will be received by the user when he reports a request.
						<br /><br /> Available shortcodes:
						<br /><br /> <strong>##receiver_id##, <br /> ##receiver_username##, <br /> ##reported_author_id##, <br /> ##reported_author_username##, <br /> ##reported_id##, <br /> ##reported_title##, <br /> ##reported_public_link##, <br /> ##report_description##, <br /> ##report_target##, <br /> ##your_site_name##, <br /> ##your_site_url##</strong>"
				),
				"report_messages" => array(
					"title"       => __( "Report message", "wpjobster" ),
					"description" =>
						"This notification will be received by the user when he reports a message.
						<br /><br /> Available shortcodes:
						<br /><br /> <strong>##receiver_id##, <br /> ##receiver_username##, <br /> ##reported_author_id##, <br /> ##reported_author_username##, <br /> ##reported_id##, <br /> ##reported_title##, <br /> ##reported_public_link##, <br /> ##report_description##, <br /> ##report_target##, <br /> ##your_site_name##, <br /> ##your_site_url##</strong>"
				),
				"report_users" => array(
					"title"       => __( "Report user", "wpjobster" ),
					"description" =>
						"This notification will be received by the user when he reports a user.
						<br /><br /> Available shortcodes:
						<br /><br /> <strong>##receiver_id##, <br /> ##receiver_username##, <br /> ##reported_author_id##, <br /> ##reported_author_username##, <br /> ##reported_id##, <br /> ##reported_title##, <br /> ##reported_public_link##, <br /> ##report_description##, <br /> ##report_target##, <br /> ##your_site_name##, <br /> ##your_site_url##</strong>"
				),
			),
		);

		$reasons['admin']['items']['report_admin'] = array(
			"title"       => __( "Report", "wpjobster" ),
			"description" =>
				"This notification will be received by the admin when any user reports something.
				<br /><br /> Available shortcodes:
				<br /><br /> <strong>##sender_id##, <br /> ##sender_username##, <br /> ##reported_author_id##, <br /> ##reported_author_username##, <br /> ##reported_id##, <br /> ##reported_title##, <br /> ##reported_public_link##, <br /> ##reported_admin_link##, <br /> ##report_description##, <br /> ##report_target##, <br /> ##your_site_name##, <br /> ##your_site_url##</strong>"
		);

		return $reasons;
	}

	function demo_content() {

		if ( get_option( 'wpj_reports_first_run_emails' ) != 'done' ) {

			update_option( 'wpj_reports_first_run_emails', 'done' );

			// email to be sent to the user who reported a job
			update_option( 'uz_email_report_jobs_en_subject', 'You have reported a job' );
			update_option( 'uz_email_report_jobs_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following job:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// email to be sent to the user who reported a request
			update_option( 'uz_email_report_requests_en_subject', 'You have reported a request' );
			update_option( 'uz_email_report_requests_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following request:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// email to be sent to the user who reported a message
			update_option( 'uz_email_report_messages_en_subject', 'You have reported a message' );
			update_option( 'uz_email_report_messages_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following message:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// email to be sent to the user who reported a user
			update_option( 'uz_email_report_users_en_subject', 'You have reported a user' );
			update_option( 'uz_email_report_users_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following user:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// email to be sent to the admin a job reported by any admin
			update_option( 'uz_email_report_admin_en_subject', 'An user has reported a ##report_target##' );
			update_option( 'uz_email_report_admin_en_message',
				'Hello admin,'.PHP_EOL.PHP_EOL.

				'##sender_username## has reported the following:'.PHP_EOL.PHP_EOL.

				'Report target: '.
				'##report_target##'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_admin_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## team.'
			);

		}

		if ( get_option( 'wpj_reports_first_run_sms' ) != 'done' ) {

			update_option( 'wpj_reports_first_run_sms', 'done' );

			// sms to be sent to the user who reported a job
			update_option( 'uz_sms_report_jobs_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following job:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// sms to be sent to the user who reported a request
			update_option( 'uz_sms_report_requests_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following request:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// sms to be sent to the user who reported a message
			update_option( 'uz_sms_report_messages_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following message:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// sms to be sent to the user who reported a user
			update_option( 'uz_sms_report_users_en_message',
				'Hello ##receiver_username##,'.PHP_EOL.PHP_EOL.

				'You have reported the following user:'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_public_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## Team'
			);

			// sms to be sent to the admin a job reported by any admin
			update_option( 'uz_sms_report_admin_en_message',
				'Hello admin,'.PHP_EOL.PHP_EOL.

				'##sender_username## has reported the following:'.PHP_EOL.PHP_EOL.

				'Report target: '.
				'##report_target##'.PHP_EOL.PHP_EOL.

				'##reported_title##'.PHP_EOL.
				'##reported_admin_link##'.PHP_EOL.PHP_EOL.

				'Report description:'.PHP_EOL.
				'##report_description##'.PHP_EOL.PHP_EOL.

				'Thank you,'.PHP_EOL.
				'##your_site_name## team.'
			);

		}

	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_AdminEmails', 'init' ) );
