<?php /*** ADMIN FILTERS ***/

class WPJREPORT_AdminFilters {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_filter( 'parse_query', array( $this, 'postTypeSelectorAction' ), 10, 1 );
			add_action( 'restrict_manage_posts', array( $this, 'postTypeSelector' ), 10, 1 );

			add_action( 'restrict_manage_posts', array( $this, 'reportsByTaxonomy' ), 10, 2 );

			add_role( 'reported', __( 'Reported' ), array( 'read' => true ) );

			add_filter( 'views_users', array( $this, 'userTypeSelector' ) );
		}
	}

	public function postTypeSelectorAction( $query ) {
		global $pagenow;

		$post_type = ( isset( $_GET['post_type'] ) ) ? $_GET['post_type'] : 'post';

		if ( ( $post_type == 'job' || $post_type == 'request' ) && $pagenow == 'edit.php' && ! empty( $_GET['report_filter'] ) && $_GET['report_filter'] == 'reported' ) {

			$meta_query = array(
				array(
					'key'     => 'reported',
					'value'   => 1,
					'compare' => '='
				)
			);

			$query->set( 'meta_query', $meta_query );

		} elseif ( ( $post_type == 'job' || $post_type == 'request' ) && $pagenow == 'edit.php' && ! empty( $_GET['report_filter'] ) && $_GET['report_filter'] == 'unreported' ) {

			$meta_query = array(
				array(
					'key'     => 'reported',
					'compare' => 'NOT EXISTS'
				)
			);

			$query->set( 'meta_query', $meta_query );

		}
	}

	public function postTypeSelector() {
		$post_type = ( isset( $_GET['post_type'] ) ) ? $_GET['post_type'] : 'post';
		if ( $post_type == 'job' || $post_type == 'request' ) {

			if ( $post_type == 'job' ) {
				$all_lbl   = __( 'All jobs', 'wpjobster' );
				$rep_lbl   = __( 'Reported jobs', 'wpjobster' );
				$unrep_lbl = __( 'Unreported jobs', 'wpjobster' );

			} elseif ( $post_type == 'request' ) {
				$all_lbl   = __( 'All requests', 'wpjobster' );
				$rep_lbl   = __( 'Reported requests', 'wpjobster' );
				$unrep_lbl = __( 'Unreported requests', 'wpjobster' );

			}

			$selcted_val = ! empty( $_GET['report_filter'] ) ? $_GET['report_filter'] : '';

			//-> templates/admin/filters-template.php
			wpj_get_report_template( 'admin/filters-template.php', array(
				'all_lbl'     => $all_lbl,
				'rep_lbl'     => $rep_lbl,
				'unrep_lbl'   => $unrep_lbl,
				'selcted_val' => $selcted_val
			) );

		}
	}

	public function userTypeSelector( $views ) {
		$user_no = count_users();

		$views['reported'] = sprintf(
			'<a href="%s">%s <span class="count">(%d)</span></a>',
			esc_url( 'users.php?role=reported' ),
			esc_html__( 'Reported', 'wpjobster' ),
			isset( $user_no['avail_roles']['reported'] ) ? $user_no['avail_roles']['reported'] : 0
		);

		return $views;
	}

	/**
	 * Add filters dropdown to admin reports
	 * to filter reports by taxonomy
	 */
	public function reportsByTaxonomy( $post_type, $which ) {

		// Apply this only on a specific post type
		if ( 'reports' !== $post_type ) return;

		// A list of taxonomy slugs to filter by
		$taxonomies = array( 'target_reports', 'reason_reports' );

		foreach ( $taxonomies as $taxonomy_slug ) {

			// Retrieve taxonomy data
			$taxonomy_obj  = get_taxonomy( $taxonomy_slug );
			$taxonomy_name = $taxonomy_obj->labels->name;

			// Retrieve taxonomy terms
			$terms = get_terms( $taxonomy_slug, ['hide_empty' => false] );

			//-> templates/admin/taxonomy-filters-template.php
			wpj_get_report_template( 'admin/taxonomy-filters-template.php', array(
				'terms'         => $terms,
				'taxonomy_name' => $taxonomy_name,
				'taxonomy_slug' => $taxonomy_slug
			) );
		}

	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_AdminFilters', 'init' ) );
