<?php /*** ADMIN METABOXES ***/

class WPJREPORT_AdminMetaboxes {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'wpj_after_admin_metaboxes', array( $this, 'setMetaboxes' ), 10, 1 );

		add_action( 'wpj_after_admin_private_message_content', array( $this, 'messageMetabox' ), 10, 1 );

		add_action( 'show_user_profile', array( $this, 'userMetabox' ), 12, 1 );
		add_action( 'edit_user_profile', array( $this, 'userMetabox' ), 12, 1 );
	}

	public function getPosts( $pid ) {
		$posts = get_posts( array(
			'post_type'      => 'reports',
			'posts_per_page' => -1,
			'post_status'    => 'any',
			'meta_query'     => array(
				array(
					'key'     => 'reported_id',
					'value'   => $pid,
					'compare' => '=',
				)
			),
		) );

		return $posts;
	}

	public function setMetaboxes() {
		add_meta_box( 'job_reports', 'Reports', array( $this, 'jobMetabox' ), 'job', 'side', 'low' );
		add_meta_box( 'request_reports', 'Reports', array( $this, 'requestMetabox' ), 'request', 'side', 'low' );
	}

	public function jobMetabox() {
		global $post;

		$posts = $this->getPosts( $post->ID );

		if ( $posts ) {
			_e( 'Users who reported this job:', 'wpjobster' );
			echo '<ul>';
				foreach ( $posts as $key => $post ) {
					$user_data = get_userdata( $post->post_author );
					echo '<li><a href="' . get_edit_post_link( $post->ID ) . '">' . ( isset( $user_data->user_login ) ? $user_data->user_login : $post->post_author ) . '</a></li>';
				}
			echo '</ul>';
		} else {
			_e( 'This job has no report.', 'wpjobster' );
		}

	}

	public function requestMetabox() {
		global $post;

		$posts = $this->getPosts( $post->ID );

		if ( $posts ) {
			_e( 'Users who reported this request:', 'wpjobster' );
			echo '<ul>';
				foreach ( $posts as $key => $post ) {
					$user_data = get_userdata( $post->post_author );
					echo '<li><a href="' . get_edit_post_link( $post->ID ) . '">' . ( isset( $user_data->user_login ) ? $user_data->user_login : $post->post_author ) . '</a></li>';
				}
			echo '</ul>';
		} else {
			_e( 'This request has no report.', 'wpjobster' );
		}
	}

	public function userMetabox( $user ) {
		$posts = $this->getPosts( $user->ID );

		if ( $posts ) {
			echo '<label style="font-weight: 600; font-size: 14px;">' . __( 'Reported by:', 'wpjobster' ) . '</label>&nbsp;';

			foreach ( $posts as $key => $post ) {
				$user_data = get_userdata( $post->post_author );
				echo '<a style="vertical-align: bottom;" href="' . get_edit_post_link( $post->ID ) . '">' . ( isset( $user_data->user_login ) ? $user_data->user_login : $post->post_author ) . '</a>';
				if ( next( $posts ) == true ) {
					echo '<span style="vertical-align: bottom;">,</span>&nbsp;';
				}
			}
		}
	}

	public function messageMetabox( $row ) {

		$posts = $this->getPosts( $row->id );

		if ( ! empty( $posts[0] ) ) {
			$user_data = get_userdata( $posts[0]->post_author );

			echo '<p><span class="red">' . __( "Reported by:", "wpjobster" ) . '</span>&nbsp;<a href="' . get_edit_user_link( $posts[0]->ID ) . '">' . ( isset( $user_data->user_login ) ? $user_data->user_login : $posts[0]->post_author ) . '</a></p>';
		}

	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_AdminMetaboxes', 'init' ) );
