<?php
add_action( 'before_delete_post', 'wpj_delete_report_by_id', 10, 1 );
add_action( 'delete_user', 'wpj_delete_report_by_id', 10, 1 );
function wpj_delete_report_by_id( $post_id = '' ) {

	if ( get_post_type( $post_id ) == 'reports' ) {

		$unique_id = get_post_meta( $post_id, 'reported_id', true );

		$target = get_post_meta( $post_id, 'reported_target', true );
		if ( $target == 'users' ) {
			delete_user_meta( $unique_id, 'reported' );

			$user_arr = new WP_User( $unique_id );
			$user_arr->remove_role( 'reported' );
		} elseif ( $target == 'jobs' || $target == 'requests' ) {
			delete_post_meta( $unique_id, 'reported' );
		}

		delete_post_meta( $post_id, 'reported_id' );
		delete_post_meta( $post_id, 'reported_target' );
		delete_post_meta( $post_id, 'reported_author' );
		delete_post_meta( $post_id, 'reported_reason' );

	}

}