<?php /*** REPORTS ***/

class WPJREPORT {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'wpj_after_single_job_sidebar_form_content', function ( $unique_id, $title ) { $this->showReportLink( $unique_id, $title, 'jobs' ); }, 10, 2 );
		add_action( 'wpj_after_single_request_buttons', function ( $unique_id, $title ) { $this->showReportLink( $unique_id, $title, 'requests' ); }, 10, 2 );
		add_action( 'wpj_after_user_profile_info_content', function ( $unique_id, $username ) { $this->showReportLink( $unique_id, $username, 'users' ); }, 10, 2 );
		add_action( 'wpj_before_message_action_buttons', function ( $unique_id, $message ) { $this->showReportLink( $unique_id, $message, 'messages' ); }, 10, 2 );

		add_action( 'wp_ajax_send_report_form', array( $this, 'sendReport' ) );
		add_action( 'wp_ajax_nopriv_send_report_form', array( $this, 'sendReport' ) );

		wpj_add_shortcode( 'user_report', array( $this, 'userProfileShortcodeFNC' ) );
		wpj_add_shortcode( 'request_report', array( $this, 'requestShortcodeFNC' ) );
	}

	/**
	 * User profile shortcode
	 */
	public function userProfileShortcodeFNC() {
		ob_start();

		$this->showReportLink( wpj_get_user_id(), wpj_get_URL_user( 'username' ), 'users' );

		return ob_get_clean();
	}

	/**
	 * Request shortcode
	 */
	public function requestShortcodeFNC() {
		ob_start();

		$this->showReportLink( wpj_get_post_id(), get_post_field( 'post_title', wpj_get_post_id() ), 'requests' );

		return ob_get_clean();
	}

	/**
	 * Show report link
	 */
	public function showReportLink( $unique_id, $title, $report_target ) {

		if ( wpj_get_option( 'wpjobster_report_' . $report_target . '_enabled' ) == 'yes' ) {

			if (
				( $report_target == 'jobs' && get_current_user_id() != get_post_field( 'post_author', $unique_id ) ) ||
				( $report_target == 'requests' && get_current_user_id() != get_post_field( 'post_author', $unique_id ) ) ||
				( $report_target == 'users' && get_current_user_id() != $unique_id ) ||
				( $report_target == 'messages' && get_current_user_id() != wpj_get_pm_notify( 'initiator', ['id' => $unique_id], 'var' ) )
			) {

				// Link classes
				$classes = is_user_logged_in() ? 'report-link cursor-pointer ' . $unique_id : 'login-link';
				if ( $report_target == 'messages' ) { $classes .= ' dib item'; }

				// Icon
				$icon = $report_target == 'messages' ? 'flag' : '';

				// Tooltip
				$tooltip = '';
				$tooltip_position = is_rtl() ? 'top right' : 'top center';

				// Text
				$text = $report_target == 'messages' ? __( 'Report', 'wpjobster' ) : '';

				// Label
				if ( $report_target == 'users' ) { $label = __( 'Report', 'wpjobster' ); }
				elseif ( $report_target == 'jobs' ) { $label = __( 'Report this job', 'wpjobster' ); }
				else { $label = ''; }

				// Label class
				$label_class = $report_target == 'users' ? 'basic red report-users-link-label' : '';

				// Button
				$button = $report_target == 'requests' ? __( "Report Request", "wpjobster" ) : '';

				// Button class
				$button_class = $report_target == 'requests' ? 'text-button-gray-outlined db mt5 mb5' : '';

				//-> templates/public/show-report-link-template.php
				wpj_get_report_template( 'public/show-report-link-template.php', array(
					'id'               => $unique_id,
					'title'            => $title,
					'report_target'    => $report_target,
					'class'            => $classes,
					'icon'             => $icon,
					'tooltip'          => $tooltip,
					'tooltip_position' => $tooltip_position,
					'text'             => $text,
					'label'            => $label,
					'label_class'      => $label_class,
					'button'           => $button,
					'button_class'     => $button_class
				) );

				$this->showModalContent( $unique_id, $title, $report_target );

			}

		}

	}

	/**
	 * Show modal content
	 */
	public function showModalContent( $unique_id, $title, $report_target ) {

		if ( $unique_id && $report_target ) {

			// Modal Title
			if ( $report_target == 'jobs' ) { $modal_title = $label = __( 'Report this job', 'wpjobster' ); }
			elseif ( $report_target == 'users' ) { $modal_title = __( 'Report this user', 'wpjobster' ); }
			elseif ( $report_target == 'messages' ) { $modal_title = __( 'Report this message', 'wpjobster' ); }
			elseif ( $report_target == 'requests' ) { $modal_title = __( 'Report this request', 'wpjobster' ); }
			else { $modal_title = ''; }

			// Reasons
			$reasons_arr = get_terms( 'reason_reports', array( 'hide_empty' => false ) );

			//-> templates/public/show-modal-content-template.php
			wpj_get_report_template( 'public/show-modal-content-template.php', array(
				'id'            => $unique_id,
				'title'         => $title,
				'label'         => $modal_title,
				'report_target' => $report_target,
				'reasons'       => $reasons_arr
			) );

		}

	}

	/**
	 * Send report to admin
	 */
	public function sendReport() {
		$report_target = WPJ_Form::post( 'target', '' );
		$title         = WPJ_Form::post( 'title', '' );
		$unique_id     = WPJ_Form::post( 'id', '' );
		$reason        = WPJ_Form::post( 'reason', '' );
		$description   = WPJ_Form::post( 'description', '' );

		$user_id = get_current_user_id();

		$title = mb_strlen( $title ) > 100 ? mb_substr( $title, 0, 25 ) . '...' : $title;

		$args = array(
			'post_type'      => 'reports',
			'posts_per_page' => 1,
			'post_status'    => 'any',
			'meta_query'     => array(
				array(
					'key'     => 'reported_id',
					'value'   => $unique_id,
					'compare' => '=',
				)
			),
			'tax_query' => array(
				array(
					'taxonomy' => 'target_reports',
					'field'    => 'slug',
					'terms'    => $report_target,
				)
			),
			'author' => $user_id
		);

		$results = new WP_Query( $args );

		if ( $report_target == 'jobs' || $report_target == 'requests' ) {
			$post_author = get_post_field( 'post_author', $unique_id );
		} elseif ( $report_target == 'users' ) {
			$post_author = $unique_id;
		} elseif ( $report_target == 'messages' ) {
			$post_author = wpj_get_pm_notify( 'initiator', ['id' => $unique_id], 'var' );
		} else {
			$post_author = '';
		}

		if ( $user_id == $post_author ) {

			$report_arr['err'] = 1;
			$report_arr['msg'] = __( "You are the author", "wpjobster" );

		} elseif ( ! $reason ) { // reason empty

			$report_arr['err'] = 1;
			$report_arr['msg'] = __( "The reason is empty", "wpjobster" );

		} elseif ( ! $description ) { // desciption empty

			$report_arr['err'] = 1;
			$report_arr['msg'] = __( "The description is empty", "wpjobster" );

		} elseif ( $results->found_posts == 0 ) { // report not exist

			$post = array(
				'post_title'   => $title,
				'post_content' => $description,
				'post_author'  => $user_id,
				'post_status'  => 'pending',
				'post_type'    => 'reports'
			);
			$post_id = wp_insert_post( $post );

			$post_reason = get_term( $reason, 'reason_reports' );

			wp_set_object_terms( $post_id, array( isset( $post_reason->slug ) ? $post_reason->slug : '' ), 'reason_reports' );
			wp_set_object_terms( $post_id, array( $report_target ), 'target_reports' );

			update_post_meta( $post_id, 'reported_id', $unique_id );
			update_post_meta( $post_id, 'reported_target', $report_target );
			update_post_meta( $post_id, 'reported_author', $post_author );
			update_post_meta( $post_id, 'reported_reason', $reason );

			if ( $report_target == 'jobs' || $report_target == 'requests' ) {
				update_post_meta( $unique_id, 'reported', 1 );
			} elseif ( $report_target == 'users' ) {
				update_user_meta( $unique_id, 'reported', 1 );

				$user_arr = new WP_User( $unique_id );
				$user_arr->add_role( 'reported' );
			}

			// send email
			$username        = get_userdata( $user_id );
			$sender_username = isset( $username->user_login ) ? wpj_get_user_display_type( $username->ID ) : $user_id;

			$author          = get_userdata( $post_author );
			$author_username = isset( $author->user_login ) ? wpj_get_user_display_type( $author->ID ) : $post_author;

			$reported_user     = get_userdata( $unique_id );
			$reported_username = isset( $reported_user->user_login ) ? wpj_get_user_display_type( $reported_user->ID ) : $unique_id;

			if ( $report_target == 'jobs' || $report_target == 'requests' ) {
				$public_link = urldecode( get_permalink( $unique_id ) );
			} elseif ( $report_target == 'users' ) {
				$public_link = urldecode( wpj_get_user_profile_link( $reported_username ) );
			} elseif ( $report_target == 'messages' ) {
				$public_link = wpj_get_pm_link( $author_username );
			} else {
				$public_link = '';
			}

			if ( $report_target == 'jobs' || $report_target == 'requests' ) {
				$admin_link = urldecode( get_edit_post_link( $unique_id ) );
			} elseif ( $report_target == 'users' ) {
				$admin_link = urldecode( get_edit_user_link( $unique_id ) );
			} elseif ( $report_target == 'messages' ) {
				$admin_link = urldecode( get_edit_user_link( $author ) );
			} else {
				$admin_link = '';
			}

			wpj_notify_user_translated( 'report_admin', 'admin', array(
				'##sender_id##'                => $user_id,
				'##sender_username##'          => $sender_username,
				'##reported_author_id##'       => $post_author,
				'##reported_author_username##' => $author_username,
				'##reported_id##'              => $unique_id,
				'##reported_title##'           => $title,
				'##reported_public_link##'     => $public_link,
				'##reported_admin_link##'      => $admin_link,
				'##report_description##'       => $description,
				'##report_target##'            => substr( $report_target, 0, -1 )
			) );

			wpj_notify_user_translated( 'report_' . $report_target, $user_id, array(
				'##receiver_id##'              => $user_id,
				'##receiver_username##'        => $sender_username,
				'##reported_author_id##'       => $post_author,
				'##reported_author_username##' => $author_username,
				'##reported_id##'              => $unique_id,
				'##reported_title##'           => $title,
				'##reported_public_link##'     => $public_link,
				'##reported_admin_link##'      => $admin_link,
				'##report_description##'       => $description,
				'##report_target##'            => substr( $report_target, 0, -1 )
			) );

			$report_arr['msg'] = __( "Your message was sent to admin!", "wpjobster" );
			$report_arr['err'] = 0;

		} else { // already reported

			$report_arr['err'] = 1;
			$report_arr['msg'] = __( "You already reported this!", "wpjobster" );

		}

		echo json_encode( $report_arr );

		wp_die();
	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT', 'init' ) );
