<?php /*** POST TYPE ***/

class WPJREPORT_PostType {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'reportsPostType' ), 9 );
	}

	/**
	 * Register appointments post type
	 */
	public function reportsPostType() {

		register_post_type( 'reports',
			array(
				'labels' => array(
					'name'               => esc_html__( 'Reports', 'wpjobster' ),
					'singular_name'      => esc_html__( 'Report', 'wpjobster' ),
					'menu_name'          => esc_html__( 'Reports', 'wpjobster' ),
					'name_admin_bar'     => esc_html__( 'Report', 'wpjobster' ),
					'add_new'            => esc_html__( 'Add New', 'wpjobster' ),
					'add_new_item'       => esc_html__( 'Add New Report', 'wpjobster' ),
					'new_item'           => esc_html__( 'New Report', 'wpjobster' ),
					'edit_item'          => esc_html__( 'Edit Report', 'wpjobster' ),
					'view_item'          => esc_html__( 'View Report', 'wpjobster' ),
					'all_items'          => esc_html__( 'All Reports', 'wpjobster' ),
					'search_items'       => esc_html__( 'Search Reports', 'wpjobster' ),
					'parent_item_colon'  => esc_html__( 'Parent Reports:', 'wpjobster' ),
					'not_found'          => esc_html__( 'No Reports found.', 'wpjobster' ),
					'not_found_in_trash' => esc_html__( 'No Reports found in Trash.', 'wpjobster' )
				),
				'public'        => true,
				'menu_position' => 34,
				'has_archive'   => 'all-reports',
				'description'   => esc_html__( 'Reports', 'wpjobster' ),
				'supports'      => array(
					'title',
					'editor',
					'author',
					'thumbnail',
					'excerpt',
					'comments'
				),
				'_builtin'           => false,
				'menu_icon'          => 'dashicons-clipboard',
				'publicly_queryable' => true,
				'hierarchical'       => false
			)
		);

	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_PostType', 'init' ) );