<?php /*** TAXONOMY ***/

class WPJREPORT_Taxonomy {

	/**
	 * Class INIT
	 */
	public static function init() {
		$class = __CLASS__; new $class;
	}

	/**
	 * Class __CONSTRUCT
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'targetTaxonomy' ) );
		add_action( 'init', array( $this, 'reasonTaxonomy' ) );
	}

	/**
	 * Register target reports taxonomy
	 */
	public function targetTaxonomy() {
		$labels = array(
			'name'                       => esc_html__( 'Report Targets', 'wpjobster' ),
			'singular_name'              => esc_html__( 'Report Target', 'wpjobster' ),
			'search_items'               => esc_html__( 'Search Report Targets', 'wpjobster' ),
			'popular_items'              => esc_html__( 'Popular Report Targets', 'wpjobster' ),
			'all_items'                  => esc_html__( 'All Report Targets', 'wpjobster' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Report Target', 'wpjobster' ),
			'update_item'                => esc_html__( 'Update Report Target', 'wpjobster' ),
			'add_new_item'               => esc_html__( 'Add New Report Target', 'wpjobster' ),
			'new_item_name'              => esc_html__( 'New Report Target Name', 'wpjobster' ),
			'separate_items_with_commas' => esc_html__( 'Separate report target with commas', 'wpjobster' ),
			'add_or_remove_items'        => esc_html__( 'Add or Remove Report Target', 'wpjobster' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used report targets', 'wpjobster' ),
			'not_found'                  => esc_html__( 'No Report Target Found.', 'wpjobster' ),
			'menu_name'                  => esc_html__( 'Report Target', 'wpjobster' ),
		);

		register_taxonomy( 'target_reports', array( 'reports' ), array( 'hierarchical' => true, 'labels' => $labels, 'show_in_menu' => false ) );
	}

	/**
	 * Register reason reports taxonomy
	 */
	public function reasonTaxonomy() {
		$labels = array(
			'name'                       => esc_html__( 'Report Reasons', 'wpjobster' ),
			'singular_name'              => esc_html__( 'Report Reason', 'wpjobster' ),
			'search_items'               => esc_html__( 'Search Report Reasons', 'wpjobster' ),
			'popular_items'              => esc_html__( 'Popular Report Reasons', 'wpjobster' ),
			'all_items'                  => esc_html__( 'All Report Reasons', 'wpjobster' ),
			'parent_item'                => null,
			'parent_item_colon'          => null,
			'edit_item'                  => esc_html__( 'Edit Report Reason', 'wpjobster' ),
			'update_item'                => esc_html__( 'Update Report Reason', 'wpjobster' ),
			'add_new_item'               => esc_html__( 'Add New Report Reason', 'wpjobster' ),
			'new_item_name'              => esc_html__( 'New Report Reason Name', 'wpjobster' ),
			'separate_items_with_commas' => esc_html__( 'Separate reason target with commas', 'wpjobster' ),
			'add_or_remove_items'        => esc_html__( 'Add or Remove Report Reason', 'wpjobster' ),
			'choose_from_most_used'      => esc_html__( 'Choose from the most used reason targets', 'wpjobster' ),
			'not_found'                  => esc_html__( 'No Report Reason Found.', 'wpjobster' ),
			'menu_name'                  => esc_html__( 'Report Reason', 'wpjobster' ),
		);

		register_taxonomy( 'reason_reports', array( 'reports' ), array( 'hierarchical' => true, 'labels' => $labels ) );
	}

}

add_action( 'after_setup_theme', array( 'WPJREPORT_Taxonomy', 'init' ) );
