<div class="ui modal report-modal <?php echo $id; ?> smaller">

	<i class="close icon"></i>

	<div class="header report text-center"><?php echo $label; ?></div>

	<div class="center content report-form-modal-wrapper mt-20">

		<?php if ( is_user_logged_in() ) { ?>

			<form action="javascript://" name="report_form" class="ui form report-form">

				<input type="hidden" name="action" value="send_report_form" />
				<input type="hidden" name="target" value="<?php echo $report_target; ?>" />
				<input type="hidden" name="title" value="<?php echo $title ?>" />
				<input type="hidden" name="id" value="<?php echo $id ?>" />

				<div class="form-wrapper">

					<div class="report-error-wrapper"></div>

					<div class="cf field mb32">

						<?php echo sprintf( __( "<h4>You are about to report the following:</h4><b>%s</b>", "wpjobster" ), wpj_apply_filter_to_string( $title, false, 'joblistings' ) ); ?>

					</div>

					<div class="cf field">

						<select name="reason" class="ui dropdown">

							<option value=""><?php _e( 'Report Reason', 'wpjobster' ); ?></option>

							<?php if ( $reasons ) {
								foreach ( $reasons as $key => $reason ) { ?>

									<option value="<?php echo $reason->term_id; ?>"><?php echo $reason->name; ?></option>

								<?php }
							} ?>

						</select>

					</div>

					<div class="field">
						<textarea name="description" placeholder="<?php _e( 'Report Description', 'wpjobster' ); ?>" class="w100"></textarea>
					</div>

					<div class="center actions">

						<div class="ui green labeled icon button report-submit">

							<i class="white checkmark icon"></i>

							<?php _e( 'Report', 'wpjobster' ); ?>

						</div>

						<div class="ui labeled icon cancel button">

							<i class="remove icon"></i>

							<?php _e( 'Cancel', 'wpjobster' ); ?>

						</div>

					</div>

				</div>

			</form>

		<?php } else _e( "Not logged in", "wpjobster" ); ?>

	</div>

</div>