<?php

// GET

if ( ! function_exists( 'wpj_get_arbitration_order' ) ) {
	function wpj_get_arbitration_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_orders_arbitration',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_arbitrations_in_review_count' ) ) {
	function wpj_get_arbitrations_in_review_count() {
		global $wpdb;

		return $wpdb->get_var(
			"
			SELECT COUNT(*)
			FROM {$wpdb->prefix}job_orders_arbitration
			WHERE seller_arbitration = 0
				AND buyer_arbitration = 0
				AND ( request_from_seller = 1 || request_from_buyer = 1 )
			"
		);
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_arbitration_order' ) ) {
	function wpj_insert_arbitration_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$data['date_request']         = current_time( 'timestamp', 1 );
		$data['message_from_support'] = '';
		$data['buyer_arbitration']    = 0;
		$data['seller_arbitration']   = 0;
		$data['date_arbitration']     = 0;

		$format[] = '%d';
		$format[] = '%s';
		$format[] = '%d';
		$format[] = '%d';
		$format[] = '%d';

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_orders_arbitration', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_arbitration_order' ) ) {
	function wpj_update_arbitration_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_orders_arbitration', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}