<?php

// GET

if ( ! function_exists( 'wpj_get_extended_delivery_order' ) ) {
	function wpj_get_extended_delivery_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_orders_extended_delivery_time',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_extend_delivery_time_order' ) ) {
	function wpj_insert_extend_delivery_time_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$data['date_request'] = current_time( 'timestamp', 1 );
		$data['user_id']      = get_current_user_id();
		$data['status']       = 0;

		$format[] = '%d';
		$format[] = '%d';
		$format[] = '%d';

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_orders_extended_delivery_time', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_extend_delivery_time_order' ) ) {
	function wpj_update_extend_delivery_time_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_orders_extended_delivery_time', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}