<?php

// GET

if ( ! function_exists( 'wpj_get_payment_order' ) ) {
	function wpj_get_payment_order( $fields = '*', $where = '', $return = 'row', $between = [] ) {
		if ( $between ) {
			if ( ! empty( $between['date_min'] ) && empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s >= %d ', $between['column'], $between['date_min'] );

			else if ( empty( $between['date_min'] ) && ! empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s <= %d ', $between['column'], $between['date_max'] );

			else if ( $between['date_min'] && $between['date_max'] )
				$where['fields_date'] = sprintf( ' AND %s >= %d AND %s <= %d', $between['column'], $between['date_min'], $between['column'], $between['date_max'] );
 		}

		$args = [
			'table'  => 'job_payment_received',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_payment_transaction' ) ) {
	function wpj_get_payment_transaction( $fields = '*', $where = '', $return = 'row', $between = [], $orderby = '', $groupby = '' ) {
		if ( $between ) {
			if ( ! empty( $between['date_min'] ) && empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s >= %d ', $between['column'], $between['date_min'] );

			else if ( empty( $between['date_min'] ) && ! empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s <= %d ', $between['column'], $between['date_max'] );

			else if ( $between['date_min'] && $between['date_max'] )
				$where['fields_date'] = sprintf( ' AND %s >= %d AND %s <= %d', $between['column'], $between['date_min'], $between['column'], $between['date_max'] );
 		}

		$args = [
			'table'  => 'job_payment_transactions',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		if ( $orderby ) {
			$args['order'] = $orderby;
		}

		if ( $groupby ) {
			$args['group'] = $groupby;
		}

		return wpj_get_query_results( $args );
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_payment_transaction' ) ) {
	function wpj_insert_payment_transaction( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_payment_transactions', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}

if ( ! function_exists( 'wpj_insert_payment' ) ) {
	function wpj_insert_payment( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_payment_received', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_payment' ) ) {
	function wpj_update_payment( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$data['payment_made_on'] = current_time( 'timestamp', 1 );

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_payment_received', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}