<?php

// GET

if ( ! function_exists( 'wpj_get_badge_order' ) ) {
	function wpj_get_badge_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_badge_orders',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_badge_order' ) ) {
	function wpj_insert_badge_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_badge_orders', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_badge_order' ) ) {
	function wpj_update_badge_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		$data['payment_date'] = current_time( 'timestamp', 1 );

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_badge_orders', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}