<?php

// GET

if ( ! function_exists( 'wpj_get_feature_order' ) ) {
	function wpj_get_feature_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_featured_orders',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_feature_job_by_page' ) ) {
	function wpj_get_feature_job_by_page( $page, $pid, $uid, $payment_status = 'pending' ) {
		global $wpdb;

		return $wpdb->get_row( $wpdb->prepare(
			"
			SELECT DISTINCT *
			FROM {$wpdb->prefix}job_featured_orders
			WHERE job_id = %d
				AND user_id = %d
				AND payment_status = %s
				AND feature_pages LIKE %s
			",
			$pid, $uid, $payment_status, '%' . $wpdb->esc_like( $page ) . '%'
		) );
	}
}

// INSERT

if ( ! function_exists( 'wpj_insert_feature_order' ) ) {
	function wpj_insert_feature_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_featured_orders', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_feature_order' ) ) {
	function wpj_update_feature_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		$data['paid_on'] = current_time( 'timestamp', 1 );

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_featured_orders', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}