<?php

// GET

if ( ! function_exists( 'wpj_get_active_subscription' ) ) {
	function wpj_get_active_subscription( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_subscriptions',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_subscription_order' ) ) {
	function wpj_get_subscription_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_subscription_orders',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_active_subscriptions' ) ) {
	function wpj_get_active_subscriptions() {
		global $wpdb;

		$table = $wpdb->prefix . 'job_subscriptions';

		return $wpdb->get_results(
			"
			SELECT * FROM $table
			WHERE next_billing_date <= '" . time() . "'
				AND next_billing_date != '0000-00-00'
				AND next_billing_date != ''
				AND next_billing_date != 0
			"
		);
	}
}

if ( ! function_exists( 'wpj_get_subscriptions_by_level_and_period' ) ) {
	function wpj_get_subscriptions_by_level_and_period( $level, $period ) {
		global $wpdb;

		$table = $wpdb->prefix . 'job_subscriptions';

		return $wpdb->get_results(
			"
			SELECT * FROM $table
			WHERE
				( subscription_level = '{$level}' AND subscription_type = '{$period}' )
				OR ( next_subscription_level = '{$level}' AND next_subscription_type = '{$period}' )
			"
		);
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_active_subscription' ) ) {
	function wpj_update_active_subscription( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_subscriptions', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}

if ( ! function_exists( 'wpj_update_subscription_order' ) ) {
	function wpj_update_subscription_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		$data['payment_date'] = current_time( 'timestamp', 1 );

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_subscription_orders', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}


// DELETE

if ( ! function_exists( 'wpj_delete_active_subscription' ) ) {
	function wpj_delete_active_subscription( $id ) {
		global $wpdb;

		if ( empty( $id ) === true ) return 0;

		$is_deleted = $wpdb->delete( $wpdb->prefix . 'job_subscriptions', ['id' => $id] );

		if ( $is_deleted === false ) return 0;

		return $is_deleted;
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_active_subscription' ) ) {
	function wpj_insert_active_subscription( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_subscriptions', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}

if ( ! function_exists( 'wpj_insert_subscription_order' ) ) {
	function wpj_insert_subscription_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_subscription_orders', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}