<?php

// GET

if ( ! function_exists( 'wpj_get_topup_order' ) ) {
	function wpj_get_topup_order( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_topup_orders',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}

if ( ! function_exists( 'wpj_get_topup_package' ) ) {
	function wpj_get_topup_package( $fields = '*', $where = '', $return = 'row' ) {
		$args = [
			'table'  => 'job_topup_packages',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		return wpj_get_query_results( $args );
	}
}


// EXIST

if ( ! function_exists( 'wpj_topup_packages_table_exist' ) ) {
	function wpj_topup_packages_table_exist() {
		global $wpdb;

		if ( $wpdb->get_var( $wpdb->prepare( "SHOW TABLES LIKE %s", $wpdb->prefix . 'job_topup_packages' ) ) === $wpdb->prefix . 'job_topup_packages' )
			return true;

		return false;
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_topup_order' ) ) {
	function wpj_insert_topup_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_topup_orders', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_topup_order' ) ) {
	function wpj_update_topup_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		$data['paid_on'] = current_time( 'timestamp', 1 );

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_topup_orders', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}