<?php

// GET

if ( ! function_exists( 'wpj_get_withdrawal_order' ) ) {
	function wpj_get_withdrawal_order( $fields = '*', $where = '', $return = 'row', $between = [], $orderby = '' ) {
		if ( $between ) {
			if ( ! empty( $between['date_min'] ) && empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s >= %d ', $between['column'], $between['date_min'] );

			else if ( empty( $between['date_min'] ) && ! empty( $between['date_max'] ) )
				$where['fields_date'] = sprintf( ' AND %s <= %d ', $between['column'], $between['date_max'] );

			else if ( $between['date_min'] && $between['date_max'] )
				$where['fields_date'] = sprintf( ' AND %s >= %d AND %s <= %d', $between['column'], $between['date_min'], $between['column'], $between['date_max'] );
 		}

		$args = [
			'table'  => 'job_withdraw',
			'fields' => $fields,
			'where'  => $where,
			'return' => $return
		];

		if ( $orderby ) {
			$args['order'] = $orderby;
		}

		return wpj_get_query_results( $args );
	}
}


// INSERT

if ( ! function_exists( 'wpj_insert_withdrawal_order' ) ) {
	function wpj_insert_withdrawal_order( $data, $format ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $format ) === true ) return 0;

		$is_inserted = $wpdb->insert( $wpdb->prefix . 'job_withdraw', $data, $format );

		if ( $is_inserted === false ) return 0;

		return $wpdb->insert_id;
	}
}


// UPDATE

if ( ! function_exists( 'wpj_update_withdrawal_order' ) ) {
	function wpj_update_withdrawal_order( $data, $where ) {
		global $wpdb;

		if ( empty( $data ) === true ) return 0;

		if ( empty( $where ) === true ) return 0;

		$is_updated = $wpdb->update( $wpdb->prefix . 'job_withdraw', $data, $where );

		if ( $is_updated === false ) return 0;

		return $is_updated;
	}
}