<?php

if ( ! function_exists( 'wpj_calculate_distance' ) ) {
	function wpj_calculate_distance( $p1, $p2 ) {
		if ( isset( $p1[0] ) && is_numeric( $p1[0] )
			&& isset( $p1[1] ) && is_numeric( $p1[1] )
			&& isset( $p2[0] ) && is_numeric( $p2[0] )
			&& isset( $p2[1] ) && is_numeric( $p2[1] )
		) {
			$units = wpj_get_option( 'wpjobster_locations_unit' ) == 'kilometers' ? 6371 : 3959;

			global $wpdb;
			$result = $wpdb->get_row( "SELECT {$units} * acos( cos( radians( {$p1[0]} ) ) * cos( radians( {$p2[0]} ) ) * cos( radians ( {$p2[1]} ) - radians( {$p1[1]} ) ) + sin( radians({$p1[0]}) ) * sin( radians ( {$p2[0]} ) ) ) as distance" );

			return $result->distance;
		}

		return false;
	}
}